package io.adbrix.sdk.domain.interactor;

import java.util.List;

import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class GetAllInAppMessageUseCase implements UseCase<Empty> {
    private final Repository repository;
    private final Completion<Result<List<DfnInAppMessage>>> completion;

    public GetAllInAppMessageUseCase(Repository repository, Completion<Result<List<DfnInAppMessage>>> completion) {
        this.repository = repository;
        this.completion = completion;
    }

    @Override
    public Empty execute() {
        repository.getAllInAppMessage(completion);
        return Empty.INSTANCE;
    }
}
