package io.adbrix.sdk.data;

public class SdkVersion {

    public static final String API_VERSION = "6.0.0";
    public static final String SDK_VERSION = "2.4.0.4";

    private SdkVersion() {
    }

    public static int compare(String leftVersion, String rightVersion) throws Exception {
        String[] splitLeftVersion = leftVersion.split("\\.");
        String[] splitRightVersion = rightVersion.split("\\.");

        if (splitLeftVersion.length != 4 || splitRightVersion.length != 4) {
            throw new Exception("Invalid SdkVersion!");
        }

        for (int i = 0; i < splitLeftVersion.length; i++) {
            if (Integer.parseInt(splitLeftVersion[i]) > Integer.parseInt(splitRightVersion[i])) {
                return 1;
            } else if (Integer.parseInt(splitLeftVersion[i]) < Integer.parseInt(splitRightVersion[i])) {
                return -1;
            }
        }

        return 0;
    }

    /**
     * Date 20221025 : Release 2.3.1.7
     * - 이벤트 처리시 Queue 상태에 따라 NullPointerException 발생하는 이슈 수정
     * - 난독화로 인해 AbxApplication, AbxDefaultDeeplinkActivity이 참조되지 않는 현상 수정
     *
     * Date 20221014 : Release 2.3.1.6
     * - V1 디퍼드 딥링크 호출 전 지연 코드 적용
     * - packageQueue 사용 중 NullPointerException 이슈 수정
     * - 코드 안정화 적용
     *
     * Date 20220916 : Release 2.3.1.5
     * - V1 ADID 값 Migration하여 가져오도록 변경
     * - SKDataSender에서 발생하는 timer.cancel() NullPointerException 수정
     * - 인앱메시지 표시중 키패드가 표시되지 않는 이슈 수정
     * - kt 라이브러리가 import되지 않았을때 종료되지 않게 수정
     *
     * Date 20220905 : Release 2.3.1.4
     * - 실패된 이벤트 처리 시 사용되는 큐에 입력시 발생하는 NullPointerException 이슈 수정
     * - 이미 cancel된 Timer가 schedule되어 발생한 illegalStateException 이슈 수정
     * - eventDatetime이 null로 들어가는 이슈 수정
     * - KT Integration 라이브러리 버전 업데이트
     * - log_id 키 값이 빠진 이벤트가 전달되지 않도록 수정
     * - 이미지 다운로드시 SDK의 SocketFactory가 적용되도록 변경
     * - 주기적으로 동작하는 Timer가 중첩으로 schedule되는 이슈 수정
     * - login시 is_user_changed 파라미터 추가
     * - 푸시 클릭 오픈 후 60초 뒤 end_session이 불린 뒤에도 open_type이 open_push가 되는 이슈 수정
     * - SDK 초기화 실패시 Side Effect를 최소화 하기 위한 Timeout  변경
     *
     * Date 20220725 : Release 2.3.1.3
     * - targetSdkVersion 30 대응
     * - targetSdkVersion 31 대응
     * - 딥링크가 포함된 Local Push 수신시 웹브라우저가 실행되는 로직 제거
     * - API 호출 실패시 순서가 꼬이는 이슈 대응
     * - LogEvent의 시간이 실제 처리된 시간과 일치하지 않는 이슈 대응
     * - 앱 최초 실행시 무조건 SET_PUSH 이벤트가 호출되는 이슈
     * - Logout API 호출시 User Properties 값이 들어가는 이슈
     * - end_session 이벤트가 중복하여 2번 호출되는 현상
     * - 앱의 DefaultSSLSocketFactory 설정에 따라 API 호출이 실패되는 현상 수정
     * - StickyInAppMessage 클릭 이벤트가 영역에 따라 다르게 동작하는 이슈 수정
     *
     * Date 20220630 : Release 2.3.1.2
     * - KT Integration 추가
     * - AdbrixRm try-catch 적용
     * - DataRegistry NullPointerException 대응
     *
     * Date 20220607 : Release 2.3.0.2
     * - FlushAllEvents Api 추가
     * - DataGramSocket error 처리
     * - proguard rule 수정
     * - EventUploadIntervalManager 수정
     *
     * Date 20220518 : Release 2.3.0.1
     * - dismissInAppMessageDialog 로직 수정
     *
     * Date 20220513 : Release 2.3.0.0
     * - InAppMessage API 추가
     *
     * Date 20220422 : Release 2.2.0.1
     * - Deeplink Id 유실 이슈 해결
     *
     * Date 20220323 : Release 2.2.0.0
     * - ActionHistory API 추가
     *
     * Date 20220223 : Release 2.1.3.0
     * - Multi Region Endpoint 추가
     * - session_order_no, event_order_no 추가
     * - event sampling 기능 추가
     * - 중복 restart 방지
     * - parsePushData, openPush API에 throws Exception 추가
     * - setRegistrationId 내부 registrationId 비교 로직 오류 수정
     *
     * Date 20220127 : Release 2.1.2.5
     * - Fix SKDataSender timer
     * - Fix EventUpload timer
     * - Handle null eventModel when logEvent
     * - Catch null parameter error when using API
     * - Fix null value return
     * - Handle fail result when calling delete/restart on initializing status
     *
     * Date 20211201 : Release 2.1.2.4
     *
     * Date 20211122 : Custom Release 2.1.2.3
     * - 대신증권 커스텀 배포
     * - AdvertisingIdClient.getAdvertisingIdInfo timeout exception 수정
     *
     * Date 20211118 : Release 2.1.2.3
     * - 앱 업데이트 후 receiver 나 푸시에 의해 백그라운드에서 초기화가 일어날 때,
     * 자동으로 진행된 migration 결과를 백그라운드 상태에서 저장하지 못한 버그 수정
     *
     * Date 20211108 : Release 2.1.2.2
     * - pause 가 시작되거나 끝날 때 이벤트를 삭제하는 로직 제거
     *
     * Date 20211105 : Release 2.1.2.1
     * - config 에서 pause = false 로 들어올 때마다
     * pause 가 해제되는 줄 알고 내부에 저장된 이벤트를 매번 삭제하는 이슈 수정
     *
     * Date 20211027 : Release 2.1.2.0
     * - pause / stop 정책 수정
     * - inappmessage restart 버그 수정
     * - Android 12 대응 (invalid gaid 핸들링)
     * - SocketClient LeakedClosableViolation 제거
     *
     * Date 20211015 : Custom Release 2.1.2.0
     * - 대신증권 커스텀 배포
     * - pause / stop 정책 수정
     *
     * Date 20210914 : Release 2.1.1.3
     * - onResume 이전에 restart, delete가 가능하도록 submit 로직 수정
     *
     * Date 20210914 : Release 2.1.1.2
     * - v1 -> v2 abx:items 변환 로직 수정
     * - 중복 restart 허용
     *
     * Date 20210906 : Release 2.1.1.1
     * - abx:abx_tracker_id 수정
     * - abx_tracker_id 를 중복 체크하는 에러 제거
     * - ncpi tracking link 처리 로직 추가
     * - V1DataProvider error 방지
     * - max event count handling logic
     * - Lazy, TryOptional 등을 이용해 ComponentFactory 리팩토링
     * - Delete / Restart 과정에서 캐시 메모리 관리 기능 개선
     *
     * Date 20210804 : Release 2.1.1.0
     * - 앱링크 성과 중복 집계 방지
     * - 동일한 abx_tid의 딥링크 이벤트 중복 발생 방지. 7일(168시간) 전에 만들어진 abx_tid도 처리하지 않음
     * - V1 → V2 로 data migration 후 V1 DB 삭제 로직 추가
     * - V1 Events Migration 기능 추가
     * - 보내지 말아야 할 Event의 log_id 가 다음 이벤트의 prev_id 로 되지 않도록 함
     * - Multiple User 모두가 각자의 SharedPreference 를 사용할 수 있도록 수정
     * - V6 API 에 맞게 DSK 로직 업데이트
     * - EventPackage ConcurrentModificationException issue 수정
     * - EventModel NullPointerException 수정
     * - identity.adid 에 값이 한 번 할당되면 그 값이 항상 유지되도록 함
     * - DELETE → RESTART 이후 Timer들의 동작 보완
     *
     * Date 20210623 : Release 2.1.0.1
     * -InAppMessage server address 오류 수정
     *
     * Date 20210622 : Release 2.1.0.0
     * - InAppMessage 기능 추가
     * - v1과 v2의 데이터베이스 호환성 추가
     * - proguard 수정
     * - v2 sharedPreference 호환성 fix
     *
     * Date 20210611 : Release 2.0.1.1
     * - Deeplink Event With Intent API
     * - AdBrixCustomLogicFlag 추가
     * - Deferred deeplink 때 중복 성과 집계 방지
     *
     * Date 20210610 : Release 2.0.1.0
     * - Parse Push Data API
     * - Open Push API
     * - Deeplink intent action error 수정
     * - Delete User and Stop SDK API
     * - Restart SDK API
     * - Parse push data API
     * - Open push tracking API
     * - Notification Channel API
     * - LogListener
     * - config variable 에 default 값 설정
     * - default event upload mode
     * - 중복 user_property update 방지
     * - EventModel Parsing error 수정
     *
     * Date 20210503 : Release 2.0.0.8
     * - separate module
     *
     * Date 20210503 : Release 2.0.0.7
     * - androidx dependency 제거
     *
     * Date 20210503 : Release 2.0.0.6
     * - Sonatype에 업로드.
     * - Sonatype library version 과 sdk version 일치시킴
     *
     * Date 20210503 :
     * - Skip 2.0.0.5 version.
     *
     * Date 20210426 : Release 2.0.0.4
     * - EventBundleModelProvider nullPointerException수정
     *
     * Date 20210420 : Release 2.0.0.3
     * - exclude logging with manifest metadata
     * - time in front of log_id is set when controller handle the event
     * - deeplink_open after remain in background state for 60 seconds bug fix(on api 29)
     * - is_push_enable default value true
     *
     * Date 20210331 : Release 2.0.0.2
     * - logging with debug app
     * - loginEvent without param, user_id only in userProperties
     * - deeplinkListener
     *
     * Date 20210323 : Release 2.0.0.1
     * - timer.cancel NullPointerException Handling
     *
     * Date 20210311 : Release 2.0.0.0
     * - Adbrix Remaster SDK v2 Release
     *
     */
}
