package com.igaworks.v2.core.result;

import io.adbrix.sdk.domain.model.SubscriptionStatus;

public class SubscriptionStatusResult extends ApiResult{
    public static final int RESULT_CODE_SUCCESS = 2000;
    public static final int RESULT_CODE_INVALID_TOKEN = 4001;
    public static final int RESULT_CODE_INVALID_REQUEST = 4002;
    public static final int RESULT_CODE_BLOCKED_ACCOUNT = 4003;
    public static final int RESULT_CODE_UNAHORIZED = 4004;
    public static final int RESULT_CODE_TERMINATED_API = 4005;
    public static final int RESULT_CODE_RATE_LIMIT_EXCEEDED = 4006;
    public static final int RESULT_CODE_INTERNAL_SERVER_ERROR = 5001;
    public static final int RESULT_CODE_SERVICE_MAINTENANCE = 5002;
    public static final int RESULT_CODE_PROPERTY_REQUIRED = -253;
    public static final int RESULT_CODE_USER_ID_REQUIRED = -254;
    public static final int RESULT_CODE_UNKNOWN_ERROR = -255;

    int result_code;
    String result_msg;

    @Override
    public boolean isSuccess() {
        if(result_code == 2000){
            return true;
        } else{
            return false;
        }
    }
    SubscriptionStatus.Type getSubscriptionTypeByValue(String value){
        switch (value){
            case "Subscribed": return SubscriptionStatus.Type.SUBSCRIBED;
            case "Unsubscribed": return SubscriptionStatus.Type.UNSUBSCRIBED;
            default: return SubscriptionStatus.Type.UNDEFINED;
        }
    }

    public int getResultCode() {
        return result_code;
    }

    public String getResultMessage() {
        return result_msg;
    }
}
