package io.adbrix.sdk.ui.inappmessage;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.view.View;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.InAppMessageClickPostingObservable;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.IAMEnums;

public interface IInAppMessageViewFactory  {
    void createInAppMessage(Activity activity, DfnInAppMessage inAppMessage, boolean isCarried);
    void dismissInAppMessage(Activity activity, IAMEnums.CloseType closeType);
    DfnInAppMessage getInAppMessage();

    class InAppMessageOnClickListener implements View.OnClickListener {
        String campaignId;
        String actionId;
        String actionType;
        String actionArg;
        InAppMessageViewListener inAppMessageViewListener;
        Runnable callback;
        InAppMessageDAO inAppMessageDAO;

        public InAppMessageOnClickListener(
                String campaignId,
                String actionId,
                String actionType,
                String actionArg,
                InAppMessageViewListener inAppMessageViewListener,
                InAppMessageDAO inAppMessageDAO,
                Runnable callback
        ) {
            this.campaignId = campaignId;
            this.actionId = actionId;
            this.actionType = actionType;
            this.actionArg = actionArg;
            this.inAppMessageViewListener = inAppMessageViewListener;
            this.inAppMessageDAO = inAppMessageDAO;
            this.callback = callback;
        }

        @Override
        public void onClick(View v) {
            try {
                if (IAMEnums.ActionType.CLOSE.getValue().equals(actionType)) {
                    InAppMessageManager.getInstance().close(IAMEnums.CloseType.ON_CLICK_FROM_CLOSE_BUTTON);
                } else if (IAMEnums.ActionType.WEBLINK.getValue().equals(actionType)) {
                    InAppMessageManager.getInstance().close(IAMEnums.CloseType.OPEN_DEEPLINK);
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(actionArg));
                    try {
                        v.getContext().startActivity(intent);
                    } catch (ActivityNotFoundException exception) {
                        AbxLog.d("ModalMessageViewFactory: ActivityNotFoundException, button action url was " + actionArg, true);
                    }
                } else if (IAMEnums.ActionType.DEEPLINK_AND_CLOSE.getValue().equals(actionType) || IAMEnums.ActionType.WEBLINK_AND_CLOSE.getValue().equals(actionType)) {
                    InAppMessageManager.getInstance().close(IAMEnums.CloseType.OPEN_DEEPLINK_AND_CLOSE);
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(actionArg));

                    try {
                        v.getContext().startActivity(intent);
                    } catch (ActivityNotFoundException exception) {
                        AbxLog.d("ModalMessageViewFactory: ActivityNotFoundException, button action url was " + actionArg, true);
                    }
                } else if (IAMEnums.ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.getValue().equals(actionType)) {
                    SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("EE", Locale.ENGLISH);

                    long currentTimeMillis = System.currentTimeMillis() + TimeZone.getDefault().getRawOffset();
                    String currentDay = localSimpleDateFormat.format(System.currentTimeMillis());

                    inAppMessageDAO.updateOneDayCloseInAppMessageTable(campaignId, currentDay, currentTimeMillis);
                    InAppMessageManager.getInstance().close(IAMEnums.CloseType.ON_CLICK_FROM_CLOSE_BUTTON);
                } else {
                    AbxLog.d("messageViewFactory: unknown button action '" + actionType + "'", true);
                }

                if (callback != null)
                    callback.run();

                InAppMessageClickPostingObservable.getInstance().postInAppMessageClickToMainThread(
                        actionId,
                        actionType,
                        actionArg,
                        IAMEnums.ActionType.CLOSE.getValue().equals(actionType)
                                || IAMEnums.ActionType.DEEPLINK_AND_CLOSE.getValue().equals(actionType)
                                || IAMEnums.ActionType.WEBLINK_AND_CLOSE.getValue().equals(actionType)
                                || IAMEnums.ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.getValue().equals(actionType)
                );
            } catch (NullPointerException nullPointerException) {
                AbxLog.d("NullPointerException in inAppMessage click action : " + nullPointerException.toString(), true);
            }
        }
    }
}
