package io.adbrix.sdk.domain.model;

import org.json.JSONObject;

import io.adbrix.sdk.component.Optional;

public class EventSamplingModel {
    public final EventSamplingType type;
    private final JSONObject eventWithProbability;

    private EventSamplingModel(EventSamplingType type, JSONObject eventWithProbability) {
        this.type = type;
        this.eventWithProbability = eventWithProbability;
    }

    public static EventSamplingModel createInstance(JSONObject jsonObject) {
        EventSamplingType type = EventSamplingType.fromInteger(jsonObject.optInt("type", -1));
        JSONObject eventWithProbability = Optional.ofNullable(jsonObject.optJSONObject("eventProbabilities"))
                .orElse(new JSONObject());

        return new EventSamplingModel(type, eventWithProbability);
    }

    public int getProbability(String eventName) {
        return eventWithProbability.optInt(eventName, -1);
    }

    public boolean contains(String eventName) {
        return eventWithProbability.has(eventName);
    }
}
