package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

import io.adbrix.sdk.component.AbxLog;

public class EventPackage {

    public final Queue<EventModel> eventModels;
    public final String packageId;

    public EventPackage(Queue<EventModel> eventModels) {
        this.eventModels = eventModels;
        this.packageId = UUID.randomUUID().toString();
    }

    public static EventPackage fromJson(JSONObject jsonObject) {
        JSONArray eventModelArray;
        Queue<EventModel> eventModelQueue = new ConcurrentLinkedQueue<>();

        try {
            eventModelArray = jsonObject.getJSONArray("eventModels");
        } catch (JSONException e) {
            AbxLog.e(e, true);
            eventModelArray = new JSONArray();
        }

        try {
            for (int i = 0; i < eventModelArray.length(); i++) {
                eventModelQueue.add(EventModel.fromJson(eventModelArray.getJSONObject(i)));
            }
        } catch (JSONException e) {
            AbxLog.e(e, true);
            return null;
        }

        return new EventPackage(eventModelQueue);
    }

    public JSONObject toJson() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray eventModelArray = new JSONArray();

        for (EventModel eventModel : eventModels) {
            if (eventModel != null) {
                eventModelArray.put(eventModel.getJson());
            }
        }
        result.put("eventModels", eventModelArray);

        return result;
    }

    @Override
    public String toString() {
        return "EventPackage{" +
                "eventModels=" + eventModels +
                ", packageId='" + packageId + '\'' +
                '}';
    }
}
