package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class OpenInAppMessageUseCase implements UseCase<Empty> {
    private final Repository repository;
    private final String campaignId;
    private final Completion<Result<Empty>> completion;

    public OpenInAppMessageUseCase(Repository repository, String campaignId, Completion<Result<Empty>> completion) {
        this.repository = repository;
        this.campaignId = campaignId;
        this.completion = completion;
    }

    @Override
    public Empty execute() {
        repository.openInAppMessage(campaignId, completion);
        return Empty.INSTANCE;
    }
}
