package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;

public interface IAMEnums {

    enum LayoutType {
        IMAGE("image"),
        IMAGE_AND_TEXT("image_and_text"),
        TEXT("text"),
        SCROLLABLE_IMAGE("scrollable_image");

        private final String value;

        LayoutType(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        public static JSONObject getSupportedLayout() {
            JSONObject supportedLayout = new JSONObject();
            JSONArray fullScreen = new JSONArray();
            JSONArray modal = new JSONArray();
            JSONArray stickyBanner = new JSONArray();

            fullScreen.put(IMAGE.getValue());
            fullScreen.put(IMAGE_AND_TEXT.getValue());
            fullScreen.put(SCROLLABLE_IMAGE.getValue());

            modal.put(IMAGE.getValue());
            modal.put(IMAGE_AND_TEXT.getValue());
            modal.put(TEXT.getValue());

            stickyBanner.put(IMAGE_AND_TEXT.getValue());

            try {
                supportedLayout.put("full_screen", fullScreen);
                supportedLayout.put("modal", modal);
                supportedLayout.put("sticky_banner", stickyBanner);
            } catch (Exception e) {
                AbxLog.e(e, true);
            }

            return supportedLayout;
        }
    }

    enum ActionType {
        CLOSE("close"),
        DEEPLINK_AND_CLOSE("deeplink_and_close"),
        WEBLINK("weblink"),
        WEBLINK_AND_CLOSE("weblink_and_close"),
        DONT_SHOW_ME_TODAY_AND_CLOSE("dont_show_me_today_and_close");

        private final String value;

        ActionType(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    enum CloseType {
        KEY_DOWN_KEYCODE_BACK,
        KEY_EVENT_KEYCODE_BACK,
        ON_CLICK_FROM_CLOSE_BUTTON,
        ON_CLICK_FROM_FRAME,
        CLOSE_BY_SWIPE_LEFT,
        CLOSE_BY_SWIPE_RIGHT,
        INVOKE_CLOSE,
        OPEN_DEEPLINK,
        OPEN_DEEPLINK_AND_CLOSE,
        ON_PAUSE
    }

    enum EventType {
        IMPRESSION("impression"),
        CLICK("click");

        private final String value;

        EventType(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    enum TextAlign {
        CENTER("center"),
        RIGHT("right"),
        LEFT("left");

        private final String value;

        TextAlign(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    enum ImageInfoHashmapValue {
        IMAGE_BITMAP("imageBitmap"),
        IMAGE_URL("imageURL"),
        IS_FIRST_SHOW("isDownLoaded"),
        CLICK_ACTION("clickAction");

        private final String value;

        ImageInfoHashmapValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    enum ScrollableImageOptionAlign {
        CENTER("center"),
        TOP("top");

        private final String value;

        ScrollableImageOptionAlign(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }
}
