package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class RestartSDKUseCase implements UseCase<Result<Empty>> {
    private final Repository repository;
    private final String userId;

    public RestartSDKUseCase(Repository repository, String userId) {
        this.repository = repository;
        this.userId = userId;
    }

    @Override
    public Result<Empty> execute() {
        return repository.restartSDK(userId);
    }
}
