package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import com.igaworks.v2.core.AdBrixRm;

import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Response;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public interface IABXContext {
    Result<String> initialize(Context context, String appkey, String secretkey);

    void getInstallReferrer();

    void saveUserProperty(UserPropertyCommand userPropertyCommand);

    Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);

    void clearUserProperty();

    void getUserId(Completion<Result<String>> completion);

    void login(String userId, Completion<Result<Response>> completion);
    void logout(Completion<Result<Response>> completion);

    void logEvent(LogEventParameter logEventParameter);

    void logSameEventWithPaging(String eventName, String group, List<JSONObject> eventParamList);

    void flushAllEvents(Completion<Result<Empty>> completion);

    void runOnIdleTime();

    void onResume(Activity activity);

    void onPause();

    void deeplink(Activity deeplinkActivity);

    void deeplinkWithIntent(Intent deeplinkIntent);

    void putDataRegistry(DataUnit dataUnit);

    Result<Empty> deleteUserData(String userId);

    Result<Empty> restartSDK(String userId);

    //ActionHistory
    void fetchActionHistoryFromServer(@Nullable String token, ActionHistoryIdType idType, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void insertPushData(String pushDataString);

    void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void deleteActionHistory(@Nullable String token, String historyId, long timestamp, Completion<Result<Empty>> completion);

    void deleteAllActionHistory(@Nullable String token, @Nullable ActionHistoryIdType idType, Completion<Result<Empty>> completion);

    void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion);

    void clearAllActionHistoryInLocalDB();

    //InAppMessage
    void fetchInAppMessage(Completion<Result<Empty>> completion);

    void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion);

    void openInAppMessage(String campaignId, Completion<Result<Empty>> completion);

    void deleteAllInAppMessageDBContents();

    void requestGetAttributionData(String logId, AdBrixRm.GetAttributionDataCallback callback, DataRegistry dataRegistry);
}
