package io.adbrix.sdk.component;

import android.content.Context;

import com.android.installreferrer.api.InstallReferrerClient;

import io.adbrix.sdk.component.autoEvent.DailyFirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.component.migration_v1.IV1DatabaseOpenHelper;
import io.adbrix.sdk.component.migration_v1.V1MigrationManager;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.data.DFNSessionState;
import io.adbrix.sdk.data.RemoteConfigProvider;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.net.IApiConnection;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.datasource.IDataContext;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.ui.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.ui.push.components.IPushEventStore;

public interface IABXComponentsFactory {

    void init(Context context, AbxFacade abxFacade, IABXContextController defaultABXContextController);

    IABXContextController getAbxContextController();

    ILogger createOrGetLogger();

    DataRegistry createOrGetDataRegistry();

    IDataContext createOrGetDataContext();

    DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider();

    DeviceStaticDataProvider createOrGetDeviceStaticDataProvider();

    V1MigrationManager createOrGetV1MigrationManager();

    Context getAndroidContext();

    void setAndroidContext(Context context);

    UserPropertyManager createOrGetUserPropertyManager();

    IEventSender createOrGetEventSender();

    IABXContext getABXContext();

    void setABXContext(IABXContext context);

    FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator();

    DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator();

    SessionAutoEventGenerator createOrGetSessionAutoEventGenerator();

    DeeplinkParameterSet createOrGetDeeplinkParameterSet();

    Repository createOrGetRepository();

    EventBuffer createOrGetEventBuffer();

    EventPackageContainer createOrGetEventPackageContainer();

    DailyFirstOpenAutoEventGenerator createOrGetDailyFirstOpenAutoEventGenerator();

    IV1DatabaseOpenHelper createOrGetV1DatabaseOpenHelper();

    EventSamplingFilter createOrGetEventSamplingFilter() ;

    IPushEventStore createOrGetPushEventStore();

    AbxPushCommonDAO createOrGetPushCommonDAO();

    IApiConnection createOrGetAPIConnection();

    InstallReferrerClient createOrGetInstallReferrerClient();

    DFNSessionState createOrGetDFNSessionState();

    RemoteConfigProvider createOrGetRemoteConfigProvider();

    EventUploadIntervalManager getEventUploadIntervalManager();
    SKDataSender getSkDataSender();
    AbxFacade getAbxFacade();

    //void activate();
    void deactivate();

    class ComponentsCanNotCreateException extends Exception {
        public ComponentsCanNotCreateException(String message) {
            super(message);
        }
    }
}


