package io.adbrix.sdk.component;

import android.os.Handler;
import android.os.Looper;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import io.adbrix.sdk.domain.model.DeferredDeeplinkObserverModel;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class DeferredDeeplinkPostingObservable implements IObservable<DeferredDeeplinkObserverModel> {
    private List<IObserver<DeferredDeeplinkObserverModel>> observers = new ArrayList<>();
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    private DeferredDeeplinkPostingObservable() {
    }

    public static DeferredDeeplinkPostingObservable getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void add(IObserver<DeferredDeeplinkObserverModel> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<DeferredDeeplinkObserverModel> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(DeferredDeeplinkObserverModel deferredDeeplink) {
        for (IObserver<DeferredDeeplinkObserverModel> observer : observers) {
            observer.update(deferredDeeplink);
        }
    }

    public void postDeferredDeeplinkToMainThread(String responseString) {
        mainThreadHandler.post(new Runnable() {
            @Override
            public void run() {
                String deferredDeeplink = "";
                int resultCode = -255;
                try {
                    JSONObject response = new JSONObject(responseString);
                    deferredDeeplink = response.optString("deeplink");
                    resultCode = response.optInt("result", -255);
                } catch (JSONException e) {
                    AbxLog.w(e, true);
                }
                if(isAvailableDeferredDeeplink(deferredDeeplink)){
                    notifyObserver(new DeferredDeeplinkObserverModel(deferredDeeplink, resultCode));
                }
            }
        });
    }
    private boolean isAvailableDeferredDeeplink(String deeplink){
        boolean result = true;
        if(CommonUtils.isNullOrEmpty(deeplink)){
            result = false;
        }
        if("null".equals(deeplink)){
            result = false;
        }
        return result;
    }

    private static class Singleton {
        private static final DeferredDeeplinkPostingObservable INSTANCE = new DeferredDeeplinkPostingObservable();
    }
}
