package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.GooglePlayReferrerProperties;
import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.modelprovider.CommonModelProvider;
import io.adbrix.sdk.data.modelprovider.EventModelProvider;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class DeferredDeeplinkModel implements IApiModel {
    private final IABXComponentsFactory componentsFactory;
    private final LogEventParameter logEventParameter;

    public DeferredDeeplinkModel(
            IABXComponentsFactory componentsFactory,
            LogEventParameter logEventParameter
    ) {
        this.componentsFactory = componentsFactory;
        this.logEventParameter = logEventParameter;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        logEventParameter.eventOrderNo = 1L;
        logEventParameter.sessionOrderNo = 1L;
        EventModelProvider eventModelProvider = new EventModelProvider(
                componentsFactory.createOrGetUserPropertyManager(),
                componentsFactory.createOrGetDataRegistry());

        eventModelProvider.setLogEventParameter(logEventParameter);
        EventModel eventModel = eventModelProvider.provide();
        CommonModel commonModel = new CommonModelProvider(
                componentsFactory.createOrGetDataRegistry(),
                componentsFactory.getAndroidContext(),
                componentsFactory.createOrGetDeviceRealtimeDataProvider()).provide();
        JSONArray evts = new JSONArray();
        try {
            if (eventModel != null) {
                evts.put(eventModel.getJson());
            }
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }

        JSONObject common = null;
        try {
            common = commonModel.getJson();
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }

        EventBundleModel eventBundleModel =  new EventBundleModel(common, evts, commonModel.appkey);
        return eventBundleModel.getJson();
    }

    @Override
    public String getUrlString() {
        String appKey = componentsFactory.createOrGetDataRegistry().safeGetString(DataRegistryKey.STRING_APPKEY, null);
        return String.format(CoreConstants.deferredDeeplinkUrlReq, appKey);
    }

    private Map<String, Object> getConvertedInstallReferrerData(Map<String, Object> googleInstallReferrerMap){
        if(CommonUtils.isNullOrEmpty(googleInstallReferrerMap)){
            return null;
        }
        if(googleInstallReferrerMap.containsKey("abx:open_type")){
            googleInstallReferrerMap.remove("abx:open_type");
        }
        if(googleInstallReferrerMap.containsKey(GooglePlayReferrerProperties.MARKET_INSTALL_BTN_CLICKED)){
            googleInstallReferrerMap.remove(GooglePlayReferrerProperties.MARKET_INSTALL_BTN_CLICKED);
        }
        if(googleInstallReferrerMap.containsKey(GooglePlayReferrerProperties.APP_INSTALL_COMPLETED)){
            googleInstallReferrerMap.remove(GooglePlayReferrerProperties.APP_INSTALL_COMPLETED);
        }
        if(googleInstallReferrerMap.containsKey(GooglePlayReferrerProperties.APP_FIRST_OPEN)){
            googleInstallReferrerMap.remove(GooglePlayReferrerProperties.APP_FIRST_OPEN);
        }
        if(googleInstallReferrerMap.containsKey(GooglePlayReferrerProperties.APP_INSTALL_START)){
            googleInstallReferrerMap.remove(GooglePlayReferrerProperties.APP_INSTALL_START);
        }
        return CommonUtils.parseValueWithDataType(googleInstallReferrerMap, CommonUtils.FixType.PREFIX);
    }

    private NullableJSONObject putGoogleReferrerData(NullableJSONObject original, Map<String, Object> map){
        if(CommonUtils.isNullOrEmpty(map)){
            return original;
        }
        Set<String> ks = map.keySet();
        Iterator<String> iterator = ks.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = (String)map.get(key);
            try {
                key = key.substring(4); //"abx:" 제거
                original.put(key, value);
            } catch (Exception e) {
                AbxLog.w(e, true);
            }
        }
        return original;
    }
}
