package io.adbrix.sdk.data.net;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.utils.CoreUtils;

public class SocketClientManager {
    private DataRegistry dataRegistry;
    private Result result;

    public SocketClientManager(DataRegistry dataRegistry, Result result) {
        this.dataRegistry = dataRegistry;
        this.result = result;
    }

    public void execute(SocketClient client) {

        if (CoreUtils.isAdbrixPause(dataRegistry)) {
            AbxLog.d("SocketClientManager :: Skip request due to pause state", true);
            return;
        }

        client.run();

        if (client.getResponseCode() == 200 || client.getResponseCode() == 201) {
            result.connectSuccess(client.getResponseCode());
        } else result.connectFail();
    }

    public interface Result {
        void connectSuccess(int responseCode);

        void connectFail();
    }
}
