package io.adbrix.sdk.component;

import java.util.ArrayList;
import java.util.List;

public class OsPushEnableObservable implements IObservable<Boolean> {

    private List<IObserver<Boolean>> observers = new ArrayList<>();

    private OsPushEnableObservable() {
    }

    public static OsPushEnableObservable getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void add(IObserver<Boolean> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<Boolean> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(Boolean object) {
        for (IObserver<Boolean> observer : observers) {
            observer.update(object);
        }
    }

    private static class Singleton {
        private static final OsPushEnableObservable INSTANCE = new OsPushEnableObservable();
    }
}
