package io.adbrix.sdk.component;

import java.util.HashMap;

import io.adbrix.sdk.domain.model.UserPropertyCommand;
import io.adbrix.sdk.domain.model.UserPropertyModel;

public interface IUserPropertyManager {
    Boolean merge(UserPropertyCommand command);
    void clear();
    UserPropertyModel getCurrentUserPropertyModel();
    Object getUserPropertyValue(String key);

    class NullUserPropertyManager implements IUserPropertyManager {
        @Override
        public Boolean merge(UserPropertyCommand command) {
            return false;
        }

        @Override
        public void clear() {

        }

        @Override
        public UserPropertyModel getCurrentUserPropertyModel() {
            return new UserPropertyModel(null, new HashMap<>());
        }

        @Override
        public Object getUserPropertyValue(String key) {
            return null;
        }
    }
}
