package com.igaworks.v2.core.application;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.utils.CoreUtils;

public class AbxDefaultDeeplinkActivity extends Activity {

    static boolean intentForward = true;
    String abxRedirectActivity = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AdBrixRm.deeplinkEvent(AbxDefaultDeeplinkActivity.this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        // singleTask launchMode case
        setIntent(intent); //now getIntent() should always return the last received intent
        AdBrixRm.deeplinkEvent(AbxDefaultDeeplinkActivity.this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        parseIntent(AbxDefaultDeeplinkActivity.this);
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    private void parseIntent(Activity activity) {

        try {

            ActivityInfo activityInfo = getPackageManager()
                    .getActivityInfo(this.getComponentName(), PackageManager.GET_META_DATA);
            if (activityInfo != null) {
                Bundle bundle = activityInfo.metaData;
                if (bundle != null && bundle.containsKey("AbxRedirectActivity")) {
                    abxRedirectActivity = String.valueOf(activityInfo.metaData.get("AbxRedirectActivity"));
                }
                if (bundle != null && bundle.containsKey("IntentForward")) {
                    intentForward = activityInfo.metaData.getBoolean("IntentForward", true);
                }
            }

            AbxLog.d("RedirectActivity: " + abxRedirectActivity + " . IntentForward: " + intentForward, true);

            try {
                if (intentForward) {
                    Intent intent = (Intent) activity.getIntent().clone();
                    intent.setClassName(this, abxRedirectActivity);

                    activity.startActivity(intent); // forward intent without ck
                    String deeplinkUrl = "null";
                    if (intent != null && intent.getData() != null) {
                        deeplinkUrl = intent.getData().toString();
                    }
                    AbxLog.d("AbxDefaultDeeplinkActivity Deeplink: " + deeplinkUrl, true);
                } else {
                    Intent intent = new Intent();
                    intent.setClassName(this, abxRedirectActivity);
                    activity.startActivity(intent);
                }

            } catch (Exception e1) {
                AbxLog.d("Can not redirect to " + abxRedirectActivity + ". Launch default activity", true);
                AbxLog.d("AbxDefaultDeeplinkActivity: " + e1.getMessage(), true);

                Intent intent = activity.getPackageManager().getLaunchIntentForPackage(activity.getPackageName());
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP |
                        Intent.FLAG_ACTIVITY_SINGLE_TOP);
                activity.startActivity(intent);
            }

        } catch (Exception e) {
            AbxLog.e(e, true);
        }
        finish();

    }
}
