package io.adbrix.sdk.ui.push.style;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;

import io.adbrix.sdk.ui.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.ui.push.utils.PushUtils;
import io.adbrix.sdk.utils.CommonUtils;

public class BigPicturePushStyle extends BigPushStyle {
    public BigPicturePushStyle(Context context, Intent intent, AbxPushCommonDAO abxPushCommonDAO) {
        super(context, intent, abxPushCommonDAO);
    }

    @Override
    protected void setBigContentView() {
        if (android.os.Build.VERSION.SDK_INT < android.os.Build.VERSION_CODES.JELLY_BEAN){
            return;
        }
        Notification.BigPictureStyle style = new Notification.BigPictureStyle();
        style.setBigContentTitle(PushUtils.fromHtml(bigTextTitle));
        if(CommonUtils.isNullOrEmpty(bigTextTitle)){
            style.setBigContentTitle(PushUtils.fromHtml(title));
        }
        if(!CommonUtils.isNullOrEmpty(summaryText)){
            style.setSummaryText(PushUtils.fromHtml(summaryText));
        }
        style.bigPicture(img);
        super.notificationBuilder.setStyle(style);
    }
}
