package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.TryOptional;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.utils.CommonUtils;

public class KakaoButton implements IDataModel {
    @Nullable public final String name;
    @Nullable public final String type;
    @Nullable public final String urlPc;
    @Nullable public final String urlMobile;
    @Nullable public final String scheme;
    @Nullable public final String chatExtra;
    @Nullable public final String chatEvent;

    public static List<KakaoButton> fromJSONString(String jsonString) {
        ArrayList<KakaoButton> kakaoButtons = new ArrayList<>();
        JSONArray jsonArray = TryOptional.of(() -> new JSONArray(jsonString))
                .orElseGet(JSONArray::new);

        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject jsonObject = jsonArray.optJSONObject(i);

            if (jsonObject != null) {
                kakaoButtons.add(
                        new KakaoButton(
                                CommonUtils.convertNullStringToNull(jsonObject.optString("name")),
                                CommonUtils.convertNullStringToNull(jsonObject.optString("type")),
                                CommonUtils.convertNullStringToNull(jsonObject.optString("url_pc")),
                                CommonUtils.convertNullStringToNull(jsonObject.optString("url_mobile")),
                                CommonUtils.convertNullStringToNull(jsonObject.optString("scheme_android")),
                                CommonUtils.convertNullStringToNull(jsonObject.optString("chat_extra")),
                                CommonUtils.convertNullStringToNull(jsonObject.optString("chat_event"))
                        )
                );
            }
        }

        return kakaoButtons;
    }

    public KakaoButton(
            @Nullable String name,
            @Nullable String type,
            @Nullable String urlPc,
            @Nullable String urlMobile,
            @Nullable String scheme,
            @Nullable String chatExtra,
            @Nullable String chatEvent
    ) {
        this.name = name;
        this.type = type;
        this.urlPc = urlPc;
        this.urlMobile = urlMobile;
        this.scheme = scheme;
        this.chatExtra = chatExtra;
        this.chatEvent = chatEvent;
    }

    @Override
    public String toString() {
        return "KakaoButton{" +
                "name='" + name + '\'' +
                ", type='" + type + '\'' +
                ", urlPc='" + urlPc + '\'' +
                ", urlMobile='" + urlMobile + '\'' +
                ", scheme='" + scheme + '\'' +
                ", chatExtra='" + chatExtra + '\'' +
                ", chatEvent='" + chatEvent + '\'' +
                '}';
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject result = new NullableJSONObject();

        result.put("name", name);
        result.put("type", type);
        result.put("url_pc", urlPc);
        result.put("url_mobile", urlMobile);
        result.put("scheme_android", scheme);
        result.put("chat_extra", chatExtra);
        result.put("chat_event", chatEvent);

        return result;
    }
}
