package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class DeleteUserDataUseCase implements UseCase<Result<Empty>> {
    private final Repository repository;
    private final String userId;

    public DeleteUserDataUseCase(Repository repository, String userId) {
        this.repository = repository;
        this.userId = userId;
    }

    @Override
    public Result<Empty> execute() {
        return repository.deleteUserData(userId);
    }
}
