package io.adbrix.sdk.data.modelprovider;

import android.content.Context;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.component.TryOptional;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.ActionHistoryDeleteModel;
import io.adbrix.sdk.domain.model.ActionHistoryError;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.CommonModel;

public class ActionHistoryDeleteModelProvider implements IApiModelProvider<ActionHistoryDeleteModel> {
    private final DataRegistry dataRegistry;
    private final Context context;
    private final DeviceRealtimeDataProvider deviceRealtimeDataProvider;
    private final IABXComponentsFactory componentsFactory;
    @Nullable
    private ActionHistoryIdType actionHistoryDeleteType;
    @Nullable
    private final String historyId;
    private final long timestamp;

    public ActionHistoryDeleteModelProvider(
            DataRegistry dataRegistry,
            Context context,
            DeviceRealtimeDataProvider deviceRealtimeDataProvider,
            IABXComponentsFactory componentsFactory,
            @Nullable
            ActionHistoryIdType actionHistoryDeleteType,
            @Nullable
            String historyId,
            long timestamp
    ) {
        this.dataRegistry = dataRegistry;
        this.context = context;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
        this.componentsFactory = componentsFactory;
        this.actionHistoryDeleteType = actionHistoryDeleteType;
        this.historyId = historyId;
        this.timestamp = timestamp;
    }

    @Override
    public ActionHistoryDeleteModel provide() {

        CommonModel commonModel = new CommonModelProvider(dataRegistry, context, deviceRealtimeDataProvider)
                .provide();

        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);
        String userId = TryOptional.of(componentsFactory::createOrGetUserPropertyManager)
                .map(userPropertyManager -> (String) userPropertyManager.getUserPropertyValue("user_id"))
                .map(id -> id.replace("string:", ""))
                .orElse(null);

        if (actionHistoryDeleteType == null) {
            actionHistoryDeleteType = userId != null ? ActionHistoryIdType.USER_ID : ActionHistoryIdType.ADID;
        }

        String id;
        if (actionHistoryDeleteType == ActionHistoryIdType.ADID) {
            id = adid;
        } else {
            id = userId;
        }

        if (appKey == null) {
            throw new RuntimeException(ActionHistoryError.NO_APPKEY_ERROR.getErrorMessage());
        }

        if (id == null) {
            throw new RuntimeException(ActionHistoryError.NULL_ID_ERROR.getErrorMessage());
        }

        return new ActionHistoryDeleteModel(
                actionHistoryDeleteType,
                appKey,
                id,
                historyId,
                timestamp,
                commonModel
        );
    }
}
