package io.adbrix.sdk.data;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class NullableJSONObject extends JSONObject {
    public NullableJSONObject() {
        super();
    }

    public NullableJSONObject(@NonNull String json) throws JSONException {
        super(json);
    }

    @Override
    public JSONObject put(String name, Object value) throws JSONException {
        value = CoreUtils.convertNullableToJSONNullable(value);
        return super.put(name, value);
    }

    @NonNull
    @Override
    public String optString(@Nullable String name) {
        String value = super.optString(name);
        if("null".equals(value)){
            return null;
        }
        return value;
    }

    @NonNull
    @Override
    public String getString(@NonNull String name) throws JSONException {
        String value = super.getString(name);
        if(CommonUtils.isNull(value)){
            return value;
        }
        if("null".equals(value)){
            return null;
        }
        return value;
    }
}
