package io.adbrix.sdk.component.autoEvent;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.DeferredDeeplinkPostingObservable;
import io.adbrix.sdk.component.GooglePlayReferrerProperties;
import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.modelprovider.DeferredDeeplinkModelProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.data.net.IApiConnection;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.IApiModel;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.utils.CommonUtils;

public class FirstOpenAutoEventGenerator {
    private final Context androidContext;
    private final DataRegistry dataRegistry;
    private final IABXComponentsFactory componentsFactory;

    public FirstOpenAutoEventGenerator(
            DataRegistry dataRegistry,
            Context androidContext,
            IABXComponentsFactory componentsFactory
    ) {
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
        this.componentsFactory = componentsFactory;
    }

    public boolean isTrigger() {
        return dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_FIRSTOPEN_ID, null) == null;
    }

//    public Map<String, Object> getFirstOpenParam() {
//        //우선순위별 검사를 한다.
//        Map<String,Object> eventProperties = null;
//
//        //1. 구글 플레이 레퍼러
//        {
//            eventProperties = this.getGooglePlayReferrerPropertiesOrNull();
//            if(eventProperties != null) {
//                return eventProperties;
//            }
//        }
//
//        //2. No 레퍼러
//        {
//            return new HashMap<>();
//        }
//    }
    public HashMap<String, Object> getGooglePlayReferrerPropertiesOrNull() {
        GooglePlayReferrerProperties googlePlayReferrerProperties = new GooglePlayReferrerProperties(androidContext, componentsFactory);
        return googlePlayReferrerProperties.getReferrerMap();
    }

    public void runDeferredDeeplinkProcess(final LogEventParameter logEventParameter) {
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);

        AbxLog.d("getDeferredDeeplink start ::: ", true);
        if(adid == null){
            AbxLog.w("AdvertisingId null, so cannot get DeferredDeeplink data", true);
            return;
        }
        if(logEventParameter == null){
            AbxLog.w("logEventParameter null, so cannot get DeferredDeeplink data", true);
            return;
        }

        /**
         * 2022.10.14 bobos
         * V1->V2 마이그레이션 과정에서 누락된 코드 추가
         * 디퍼드 딥링크가 동작하기 전 서버에 사전 작업이 있어 Delay가 필요하다고함
         */
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    Thread.sleep(1000);
                    ApiConnectionManager<Void> apiConnectionManager = new ApiConnectionManager<>(new ApiConnectionManager.Result<Void>() {
                        @Override
                        public void connectSuccess(String responseString, int responseCode, Void unused) {
                            AbxLog.d("Terminated FirstOpen", true);
                            AbxLog.i("API getDeferredDeeplink connectSuccess !! " + responseString, true);
                            String result = getDeferredDeeplinkResponse(responseString);
                            if(CommonUtils.isNullOrEmpty(result)){
                                return;
                            }
                            DeferredDeeplinkPostingObservable.getInstance().postDeferredDeeplinkToMainThread(responseString);
                        }

                        @Override
                        public void connectFail(int responseCode, Void unused) {
                            AbxLog.d("Terminated FirstOpen", true);
                            AbxLog.w("API getDeferredDeeplink connectFail !! ", true);
//                    AbxLog.d("DeferredDeeplink responseCode : " + responseCode, true);
                        }
                    }, null);

                    IApiModel deferredDeeplinkModel = new DeferredDeeplinkModelProvider(componentsFactory, logEventParameter).provide();
                    IApiConnection apiConnection = componentsFactory.createOrGetAPIConnection().post(deferredDeeplinkModel);
                    apiConnectionManager.executeWithRetryByResultCode(apiConnection);
                } catch (InterruptedException e) {
                    AbxLog.e(e, true);
                }
            }
        }).start();
    }

    /**
     * 2022.11.22 bobos
     * 기존과 동일하게 deeplink가 null일 경우 콜백 전달하지 않음
     * @param responseString
     * @return
     */
    private String getDeferredDeeplinkResponse(String responseString){
        String result = "";
        if(CommonUtils.isNullOrEmpty(responseString)){
            return result;
        }
        try {
            JSONObject jsonObject = new JSONObject(responseString);
            if(jsonObject.has("result")){
                jsonObject.remove("result");
            }
            String deeplink = jsonObject.getString("deeplink");
            if(CommonUtils.isNullOrEmpty(deeplink)){
                return result;
            }
            if("null".equals(deeplink)){
                return result;
            }
            result = jsonObject.toString();
            return result;
        } catch (JSONException e) {
            AbxLog.w(e, true);
        }
        return result;
    }
}
