package io.adbrix.sdk.component;

import android.content.Context;

import com.android.installreferrer.api.InstallReferrerClient;

import io.adbrix.sdk.component.autoEvent.DailyFirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.component.migration_v1.IV1DatabaseOpenHelper;
import io.adbrix.sdk.component.migration_v1.V1DatabaseOpenHelper;
import io.adbrix.sdk.component.migration_v1.V1MigrationManager;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.data.DFNSessionState;
import io.adbrix.sdk.data.RemoteConfigProvider;
import io.adbrix.sdk.data.dataprovider.DefaultNowaitEventNameProvider;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.dataprovider.GoogleAdvertisingIdProvider;
import io.adbrix.sdk.data.dataprovider.IGoogleAdvertisingIdProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.EmptyApiConnection;
import io.adbrix.sdk.data.net.IApiConnection;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.RepositoryImpl;
import io.adbrix.sdk.data.repository.datasource.DefaultDataContext;
import io.adbrix.sdk.data.repository.datasource.IDataContext;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.ui.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.ui.push.components.IPushEventStore;
import io.adbrix.sdk.ui.push.components.PushEventSqliteStore;
import io.adbrix.sdk.utils.CommonUtils;

public class DefaultComponentsFactory implements IABXComponentsFactory {

    protected Context androidContext;
    protected AbxFacade abxFacade;
    protected IABXContext abxContext;
    protected IABXContextController defaultABXContextController;
    protected ILogger logger;
    protected IDataContext dataContext;
    protected DataRegistry dataRegistry;
    protected Repository repository;

    protected DeviceRealtimeDataProvider deviceRealtimeDataProvider;
    protected DeviceStaticDataProvider deviceStaticDataProvider;
    protected UserPropertyManager userPropertyManager;
    protected V1MigrationManager v1MigrationManager;
    protected IEventSender eventSender;
    protected DeeplinkParameterSet deeplinkParameterSet;
    protected FirstOpenAutoEventGenerator firstOpenAutoEventGenerator;
    protected DeeplinkAutoEventGenerator deeplinkAutoEventGenerator;
    protected DailyFirstOpenAutoEventGenerator dailyFirstOpenAutoEventGenerator;
    protected SessionAutoEventGenerator sessionAutoEventGenerator;
    protected EventBuffer eventBuffer;
    protected EventPackageContainer eventPackageContainer;
    protected IV1DatabaseOpenHelper v1DatabaseOpenHelper;
    protected EventSamplingFilter eventSamplingFilter;
    protected IGoogleAdvertisingIdProvider googleAdvertisingIdProvider;
    protected IPushEventStore pushEventStore;
    protected AbxPushCommonDAO pushCommonDAO;
    protected DFNSessionState dfnSessionState;
    protected RemoteConfigProvider remoteConfigProvider;
    protected EventUploadIntervalManager eventUploadIntervalManager;
    protected SKDataSender skDataSender;

    @Override
    public void init(Context context, AbxFacade abxFacade, IABXContextController defaultABXContextController) {
        this.abxFacade = abxFacade;
        this.defaultABXContextController = defaultABXContextController;
        this.androidContext = context;
        this.setupFactory();
    }

    @Override
    public IABXContextController getAbxContextController() {
        return this.defaultABXContextController;
    }

    /***
     * 컴포넌트 생성방식을 정의합니다.
     * 서브클래스에서 해당 방식을 재정의할 수 있습니다.
     */
    protected void setupFactory() {
        this.logger = new DefaultLogger();
        this.dfnSessionState = new DFNSessionState();
        this.dataContext = new DefaultDataContext(this.androidContext);
        this.dataRegistry = new DataRegistry(this.dataContext, this.logger);
        this.googleAdvertisingIdProvider = new GoogleAdvertisingIdProvider(androidContext);
        this.deviceRealtimeDataProvider = new DeviceRealtimeDataProvider(this.dataRegistry, this.androidContext, this.defaultABXContextController, this.googleAdvertisingIdProvider);
        this.deviceStaticDataProvider = new DeviceStaticDataProvider(this.dataRegistry, this.androidContext);
        this.v1DatabaseOpenHelper = new V1DatabaseOpenHelper(this.androidContext);
        this.eventSamplingFilter = new EventSamplingFilter(this.dataRegistry);
        this.pushEventStore = PushEventSqliteStore.createAndGetPushEventSqliteStore(this.androidContext);
        this.pushCommonDAO = new AbxPushCommonDAO(this.abxFacade, this.pushEventStore);
        this.userPropertyManager = new UserPropertyManager(this.dataContext,this.logger,this.dataRegistry);
        this.deeplinkParameterSet = new DeeplinkParameterSet(this.dataRegistry);
        this.deeplinkAutoEventGenerator = new DeeplinkAutoEventGenerator(this.dataRegistry,this.deeplinkParameterSet);
        this.eventUploadIntervalManager = new EventUploadIntervalManager();
        this.eventSender = new DefaultEventSender(this.dataRegistry, this.androidContext, this.deviceRealtimeDataProvider, createOrGetAPIConnection());
        this.eventPackageContainer = new EventPackageContainer(eventUploadIntervalManager, this.eventSender,this.dataRegistry);
        this.eventBuffer = new EventBuffer(eventUploadIntervalManager, this.eventPackageContainer,new DefaultNowaitEventNameProvider(), this.abxFacade);
        this.skDataSender = new SKDataSender(dataRegistry);
        this.remoteConfigProvider = new RemoteConfigProvider(this.dataRegistry, this.androidContext, createOrGetAPIConnection());
        this.v1MigrationManager = new V1MigrationManager(this.dataRegistry,this.userPropertyManager,this.v1DatabaseOpenHelper,this.eventPackageContainer,this.remoteConfigProvider);
        this.firstOpenAutoEventGenerator = new FirstOpenAutoEventGenerator(this.dataRegistry, this.androidContext,this);
        this.repository = new RepositoryImpl(this);
        this.sessionAutoEventGenerator = new SessionAutoEventGenerator(this.dataRegistry,this.firstOpenAutoEventGenerator,this.repository,this.deeplinkParameterSet,this.v1MigrationManager,this.dfnSessionState, this.remoteConfigProvider);
        this.dailyFirstOpenAutoEventGenerator = new DailyFirstOpenAutoEventGenerator(this.dataRegistry, this.repository, this.dfnSessionState, this.remoteConfigProvider);
    }

    @Override
    public Context getAndroidContext()  {
        return this.androidContext;
    }

    @Override
    public void setAndroidContext(Context context) {
        this.androidContext = context;
    }

    @Override
    public UserPropertyManager createOrGetUserPropertyManager(){
        return this.userPropertyManager;
    }

    @Override
    public IEventSender createOrGetEventSender() {
        return this.eventSender;
    }

    @Override
    public IABXContext getABXContext() {
        return this.abxContext;
    }

    @Override
    public void setABXContext(IABXContext context) {
        this.abxContext = context;
    }

    @Override
    public FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator()  {
        return this.firstOpenAutoEventGenerator;
    }

    @Override
    public SessionAutoEventGenerator createOrGetSessionAutoEventGenerator()  {
        return this.sessionAutoEventGenerator;
    }

    @Override
    public DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator()  {
        return this.deeplinkAutoEventGenerator;
    }



    @Override
    public ILogger createOrGetLogger() {
        try {
            return this.logger;
        } catch (Exception e) {
            return new DefaultLogger();
        }
    }

    @Override
    public DataRegistry createOrGetDataRegistry(){
        return this.dataRegistry;
    }

    @Override
    public IDataContext createOrGetDataContext() {
        return this.dataContext;
    }

    @Override
    public DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider()  {
        return this.deviceRealtimeDataProvider;
    }

    @Override
    public DeviceStaticDataProvider createOrGetDeviceStaticDataProvider() {
        return this.deviceStaticDataProvider;
    }

    @Override
    public V1MigrationManager createOrGetV1MigrationManager() {
        return this.v1MigrationManager;
    }

    @Override
    public DeeplinkParameterSet createOrGetDeeplinkParameterSet()  {
        return this.deeplinkParameterSet;
    }

    @Override
    public Repository createOrGetRepository()  {
        return this.repository;
    }

    @Override
    public EventBuffer createOrGetEventBuffer()  {
        return this.eventBuffer;
    }

    @Override
    public EventPackageContainer createOrGetEventPackageContainer()  {
        return this.eventPackageContainer;
    }

    @Override
    public DailyFirstOpenAutoEventGenerator createOrGetDailyFirstOpenAutoEventGenerator()  {
        return this.dailyFirstOpenAutoEventGenerator;
    }

    @Override
    public IV1DatabaseOpenHelper createOrGetV1DatabaseOpenHelper()  {
        return this.v1DatabaseOpenHelper;
    }

    @Override
    public EventSamplingFilter createOrGetEventSamplingFilter()  {
        return this.eventSamplingFilter;
    }

    @Override
    public IPushEventStore createOrGetPushEventStore()  {
        return this.pushEventStore;
    }

    @Override
    public AbxPushCommonDAO createOrGetPushCommonDAO()  {
        return this.pushCommonDAO;
    }

    @Override
    public IApiConnection createOrGetAPIConnection(){
        try {
            return new ApiConnection(dataRegistry);
        } catch (Exception e) {
            AbxLog.e("APIConnection 초기화에 실패하여, 빈 APIConnection을 사용합니다. (아무런 동작도 하지 않습니다.)",true);
            return new EmptyApiConnection();
        }
    }

    @Override
    public InstallReferrerClient createOrGetInstallReferrerClient() {
        return InstallReferrerClient.newBuilder(this.androidContext).build();
    }

    @Override
    public DFNSessionState createOrGetDFNSessionState() {
        return this.dfnSessionState;
    }

    @Override
    public RemoteConfigProvider createOrGetRemoteConfigProvider() {
        return this.remoteConfigProvider;
    }

    @Override
    public void deactivate() {
        if(CommonUtils.notNull(this.skDataSender)){
            this.skDataSender.setTimerToNull();
        }
        if(CommonUtils.notNull(this.dailyFirstOpenAutoEventGenerator)){
            this.dailyFirstOpenAutoEventGenerator.setTimerToNull();
        }
        if(CommonUtils.notNull(this.eventUploadIntervalManager)){
            this.eventUploadIntervalManager.setTimerToNull();
            this.eventUploadIntervalManager.deleteAllObservers();
        }
    }

    public EventUploadIntervalManager getEventUploadIntervalManager(){
        return eventUploadIntervalManager;
    }

    @Override
    public SKDataSender getSkDataSender() {
        return skDataSender;
    }

    @Override
    public AbxFacade getAbxFacade() {
        return this.abxFacade;
    }
}
