package com.igaworks.v2.core.result;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.CommonUtils;

public class ResultWithDeeplink extends Result{
    protected Context context;
    protected String deeplink;
    public void openViewByDeeplink(){
        if(CommonUtils.isNullOrEmpty(deeplink)){
            AbxLog.d("deeplink is empty", false);
            return;
        }
        Uri uri = null;
        try {
            uri = Uri.parse(deeplink);
        }catch (Exception e){
            AbxLog.d("deeplink parsing error", false);
            return;
        }
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public String getDeeplink() {
        return deeplink;
    }

    @Override
    public String toString() {
        return "Result{" +
                "deeplink='" + deeplink + '\'' +
                '}';
    }
}
