package com.igaworks.v2.core.result;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.model.AttributionModel;
import io.adbrix.sdk.utils.CommonUtils;

public class GetAttributionDataResult extends ApiResult{
    public enum Result{
        HAS_ATTRIBUTION(0),
        ORGANIC(1),
        ORGANIC_POLICY_VIOLATION(2),
        NO_CONVERSION(-1),
        ORGANIC_IN_NCPI_PROGRESS(-2),
        NETWORK_ERROR(-255);
        private static final HashMap<Integer, Result> valueMap = new HashMap<>();
        static {
            for(Result value : values()){
                valueMap.put(value.getValue(), value);
            }
        }
        private final int value;
        Result(int value){
            this.value = value;
        }
        public static Result getResultByValue(int value){
            return valueMap.get(value);
        }
        public int getValue() {
            return value;
        }
    }

    private int result = Result.NO_CONVERSION.getValue();
    private String attribution_result;
    private String evt_log_id;
    private String server_datetime;
    private String adtouch_datetime;
    private String attribute_datetime;
    private String event_datetime;
    private String partner;
    private String partner_name;
    private String tracker_id;
    private String tracker_name;
    private String campaign_id;
    private String campaign_name;
    private String i_request_type;
    private String attr_type;
    private String fraud_reason;
    private String m_publisher;
    private String m_adgroup;
    private String m_ad;
    private String m_keyword;
    private String m_placement;
    private String m_cost_model;
    private String m_cost;
    private String m_cost_currency;
    private String m_play_percent;
    private String m_play_second;
    private String m_view_percent;
    private String m_view_second;
    private String m_creative;
    private String m_sub_publisher;
    private String m_campaign;
    private String m_rank;
    private String m_campaign_type;
    private String m_media;
    private String m_keyword_id;
    private String m_contract;
    private String m_network;
    private String m_match;
    private String m_ad_extension;
    private String m_adgroup_id;
    private String m_campaign_id;
    private String m_campaign_group_id;
    private String m_campaign_group;
    private String m_account_id;
    private String utm_source;
    private String utm_medium;
    private String utm_campaign;
    private String utm_term;
    private String utm_content;
    private String adv_adgroup;
    private String adv_ad;
    private String adv_campaign;
    private String adv_creative;
    private String adv_keyword;
    private String adv_agency;
    private String adv_placement;
    private String adv_cost_model;
    private String adv_cost;
    private String adv_currency;
    private JSONObject attributionData;

    public GetAttributionDataResult(int statusCode, int result) {
        super.statusCode = statusCode;
        this.result = result;
    }
    public GetAttributionDataResult(int statusCode, String responseBody){
        super.statusCode = statusCode;
        if(CommonUtils.isNullOrEmpty(responseBody)){
            return;
        }
        try {
            NullableJSONObject jsonObject = new NullableJSONObject(responseBody);
            this.result = jsonObject.optInt(AttributionModel.RESPONSE_RESULT);
            this.attribution_result = jsonObject.optString(AttributionModel.RESPONSE_ATTRIBUTION_RESULT);
            this.evt_log_id = jsonObject.optString(AttributionModel.RESPONSE_EVT_LOG_ID);
            this.server_datetime = jsonObject.optString(AttributionModel.RESPONSE_SERVER_DATETIME);
            this.adtouch_datetime = jsonObject.optString(AttributionModel.RESPONSE_ADTOUCH_DATETIME);
            this.attribute_datetime = jsonObject.optString(AttributionModel.RESPONSE_ATTRIBUTE_DATETIME);
            this.event_datetime = jsonObject.optString(AttributionModel.RESPONSE_EVENT_DATETIME);
            this.partner = jsonObject.optString(AttributionModel.RESPONSE_PARTNER);
            this.partner_name = jsonObject.optString(AttributionModel.RESPONSE_PARTNER_NAME);
            this.tracker_id = jsonObject.optString(AttributionModel.RESPONSE_TRACKER_ID);
            this.tracker_name = jsonObject.optString(AttributionModel.RESPONSE_TRACKER_NAME);
            this.campaign_id = jsonObject.optString(AttributionModel.RESPONSE_CAMPAIGN_ID);
            this.campaign_name = jsonObject.optString(AttributionModel.RESPONSE_CAMPAIGN_NAME);
            this.i_request_type = jsonObject.optString(AttributionModel.RESPONSE_I_REQUEST_TYPE);
            this.attr_type = jsonObject.optString(AttributionModel.RESPONSE_ATTR_TYPE);
            this.fraud_reason = jsonObject.optString(AttributionModel.RESPONSE_FRAUD_REASON);
            this.m_publisher = jsonObject.optString(AttributionModel.RESPONSE_M_PUBLISHER);
            this.m_adgroup = jsonObject.optString(AttributionModel.RESPONSE_M_ADGROUP);
            this.m_ad = jsonObject.optString(AttributionModel.RESPONSE_M_AD);
            this.m_keyword = jsonObject.optString(AttributionModel.RESPONSE_M_KEYWORD);
            this.m_placement = jsonObject.optString(AttributionModel.RESPONSE_M_PLACEMENT);
            this.m_cost_model = jsonObject.optString(AttributionModel.RESPONSE_M_COST_MODEL);
            this.m_cost = jsonObject.optString(AttributionModel.RESPONSE_M_COST);
            this.m_cost_currency = jsonObject.optString(AttributionModel.RESPONSE_M_COST_CURRENCY);
            this.m_play_percent = jsonObject.optString(AttributionModel.RESPONSE_M_PLAY_PERCENT);
            this.m_play_second = jsonObject.optString(AttributionModel.RESPONSE_M_PLAY_SECOND);
            this.m_view_percent = jsonObject.optString(AttributionModel.RESPONSE_M_VIEW_PERCENT);
            this.m_view_second = jsonObject.optString(AttributionModel.RESPONSE_M_VIEW_SECOND);
            this.m_creative = jsonObject.optString(AttributionModel.RESPONSE_M_CREATIVE);
            this.m_sub_publisher = jsonObject.optString(AttributionModel.RESPONSE_M_SUB_PUBLISHER);
            this.m_campaign = jsonObject.optString(AttributionModel.RESPONSE_M_CAMPAIGN);
            this.m_rank = jsonObject.optString(AttributionModel.RESPONSE_M_RANK);
            this.m_campaign_type = jsonObject.optString(AttributionModel.RESPONSE_M_CAMPAIGN_TYPE);
            this.m_media = jsonObject.optString(AttributionModel.RESPONSE_M_MEDIA);
            this.m_keyword_id = jsonObject.optString(AttributionModel.RESPONSE_M_KEYWORD_ID);
            this.m_contract = jsonObject.optString(AttributionModel.RESPONSE_M_CONTRACT);
            this.m_network = jsonObject.optString(AttributionModel.RESPONSE_M_NETWORK);
            this.m_match = jsonObject.optString(AttributionModel.RESPONSE_M_MATCH);
            this.m_ad_extension = jsonObject.optString(AttributionModel.RESPONSE_M_AD_EXTENSION);
            this.m_adgroup_id = jsonObject.optString(AttributionModel.RESPONSE_M_ADGROUP_ID);
            this.m_campaign_id = jsonObject.optString(AttributionModel.RESPONSE_M_CAMPAIGN_ID);
            this.m_campaign_group_id = jsonObject.optString(AttributionModel.RESPONSE_M_CAMPAIGN_GROUP_ID);
            this.m_campaign_group = jsonObject.optString(AttributionModel.RESPONSE_M_CAMPAIGN_GROUP);
            this.m_account_id = jsonObject.optString(AttributionModel.RESPONSE_M_ACCOUNT_ID);
            this.utm_source = jsonObject.optString(AttributionModel.RESPONSE_UTM_SOURCE);
            this.utm_medium = jsonObject.optString(AttributionModel.RESPONSE_UTM_MEDIUM);
            this.utm_campaign = jsonObject.optString(AttributionModel.RESPONSE_UTM_CAMPAIGN);
            this.utm_term = jsonObject.optString(AttributionModel.RESPONSE_UTM_TERM);
            this.utm_content = jsonObject.optString(AttributionModel.RESPONSE_UTM_CONTENT);
            this.adv_adgroup = jsonObject.optString(AttributionModel.RESPONSE_ADV_ADGROUP);
            this.adv_ad = jsonObject.optString(AttributionModel.RESPONSE_ADV_AD);
            this.adv_campaign = jsonObject.optString(AttributionModel.RESPONSE_ADV_CAMPAIGN);
            this.adv_creative = jsonObject.optString(AttributionModel.RESPONSE_ADV_CREATIVE);
            this.adv_keyword = jsonObject.optString(AttributionModel.RESPONSE_ADV_KEYWORD);
            this.adv_agency = jsonObject.optString(AttributionModel.RESPONSE_ADV_AGENCY);
            this.adv_placement = jsonObject.optString(AttributionModel.RESPONSE_ADV_PLACEMENT);
            this.adv_cost_model = jsonObject.optString(AttributionModel.RESPONSE_ADV_COST_MODEL);
            this.adv_cost = jsonObject.optString(AttributionModel.RESPONSE_ADV_COST);
            this.adv_currency = jsonObject.optString(AttributionModel.RESPONSE_ADV_CURRENCY);
            this.attributionData = jsonObject;
            this.attributionData.remove(AttributionModel.RESPONSE_RESULT);
            this.attributionData.remove(AttributionModel.RESPONSE_ATTRIBUTION_RESULT);
        } catch (JSONException e) {
            AbxLog.w(e, false);
        }
    }

    public Result getResult() {
        return Result.getResultByValue(result);
    }

    public String getAttributionResult(){
        return attribution_result;
    }
    public String getEvtLogId(){
        return evt_log_id;
    }
    public String getServerDatetime(){
        return server_datetime;
    }
    public String getAdtouchDatetime(){
        return adtouch_datetime;
    }
    public String getAttributeDatetime(){
        return attribute_datetime;
    }
    public String getEventDatetime(){
        return event_datetime;
    }
    public String getPartner(){
        return partner;
    }
    public String getPartnerName(){
        return partner_name;
    }
    public String getTrackerId(){
        return tracker_id;
    }
    public String getTrackerName(){
        return tracker_name;
    }
    public String getCampaignId(){
        return campaign_id;
    }
    public String getCampaignName(){
        return campaign_name;
    }
    public String getIRequestType(){
        return i_request_type;
    }
    public String getAttrType(){
        return attr_type;
    }
    public String getFraudReason(){
    return fraud_reason;
    }
    public String getMPublisher(){
        return m_publisher;
    }
    public String getMAdgroup(){
        return m_adgroup;
    }
    public String getMAd(){
        return m_ad;
    }
    public String getMKeyword(){
        return m_keyword;
    }
    public String getMPlacement(){
        return m_placement;
    }
    public String getMCostModel(){
        return m_cost_model;
    }
    public String getMCost(){
        return m_cost;
    }
    public String getMCostCurrency(){
        return m_cost_currency;
    }
    public String getMPlayPercent(){
        return m_play_percent;
    }
    public String getMPlaySecond(){
        return m_play_second;
    }
    public String getMViewPercent(){
        return m_view_percent;
    }
    public String getMViewSecond(){
        return m_view_second;
    }
    public String getMCreative(){
        return m_creative;
    }
    public String getMSubPublisher(){
        return m_sub_publisher;
    }
    public String getMCampaign(){
        return m_campaign;
    }
    public String getMRank(){
        return m_rank;
    }
    public String getMCampaignType(){
        return m_campaign_type;
    }
    public String getMMedia(){
        return m_media;
    }
    public String getMKeywordId(){
        return m_keyword_id;
    }
    public String getMContract(){
        return m_contract;
    }
    public String getMNetwork(){
        return m_network;
    }
    public String getMMatch(){
        return m_match;
    }
    public String getMAdExtension(){
        return m_ad_extension;
    }
    public String getMAdgroupId(){
        return m_adgroup_id;
    }
    public String getMCampaignId(){
        return m_campaign_id;
    }
    public String getMCampaignGroupId(){
        return m_campaign_group_id;
    }
    public String getMCampaignGroup(){
        return m_campaign_group;
    }
    public String getMAccountId(){
        return m_account_id;
    }
    public String getUtmSource(){
        return utm_source;
    }
    public String getUtmMedium(){
        return utm_medium;
    }
    public String getUtmCampaign(){
        return utm_campaign;
    }
    public String getUtmTerm(){
        return utm_term;
    }
    public String getUtmContent(){
        return utm_content;
    }
    public String getAdvAdgroup(){
        return adv_adgroup;
    }
    public String getAdvAd(){
        return adv_ad;
    }
    public String getAdvCampaign(){
        return adv_campaign;
    }
    public String getAdvCreative(){
        return adv_creative;
    }
    public String getAdvKeyword(){
        return adv_keyword;
    }
    public String getAdvAgency(){
        return adv_agency;
    }
    public String getAdvPlacement(){
        return adv_placement;
    }
    public String getAdvCostModel(){
        return adv_cost_model;
    }
    public String getAdvCost(){
        return adv_cost;
    }
    public String getAdvCurrency(){
        return adv_currency;
    }

    public JSONObject getAttributionData() {
        return attributionData;
    }

    @Override
    public boolean isSuccess() {
        boolean value = false;
        if(super.statusCode != 200){
            return value;
        }
        if(result < 0){
            return value;
        }
        value = true;
        return value;
    }

    @Override
    public String toString() {
        return "GetAttributionDataResult{" +
                "statusCode=" + statusCode +
                ", result=" + result +
                ", attribution_result='" + attribution_result + '\'' +
                ", evt_log_id='" + evt_log_id + '\'' +
                ", server_datetime='" + server_datetime + '\'' +
                ", adtouch_datetime='" + adtouch_datetime + '\'' +
                ", attribute_datetime='" + attribute_datetime + '\'' +
                ", event_datetime='" + event_datetime + '\'' +
                ", partner='" + partner + '\'' +
                ", partner_name='" + partner_name + '\'' +
                ", tracker_id='" + tracker_id + '\'' +
                ", tracker_name='" + tracker_name + '\'' +
                ", campaign_id='" + campaign_id + '\'' +
                ", campaign_name='" + campaign_name + '\'' +
                ", i_request_type=" + i_request_type +
                ", attr_type=" + attr_type +
                ", fraud_reason='" + fraud_reason + '\'' +
                ", m_publisher='" + m_publisher + '\'' +
                ", m_adgroup='" + m_adgroup + '\'' +
                ", m_ad='" + m_ad + '\'' +
                ", m_keyword='" + m_keyword + '\'' +
                ", m_placement='" + m_placement + '\'' +
                ", m_cost_model=" + m_cost_model +
                ", m_cost=" + m_cost +
                ", m_cost_currency='" + m_cost_currency + '\'' +
                ", m_play_percent='" + m_play_percent + '\'' +
                ", m_play_second='" + m_play_second + '\'' +
                ", m_view_percent='" + m_view_percent + '\'' +
                ", m_view_second='" + m_view_second + '\'' +
                ", m_creative='" + m_creative + '\'' +
                ", m_sub_publisher='" + m_sub_publisher + '\'' +
                ", m_campaign='" + m_campaign + '\'' +
                ", m_rank=" + m_rank +
                ", m_campaign_type=" + m_campaign_type +
                ", m_media='" + m_media + '\'' +
                ", m_keyword_id='" + m_keyword_id + '\'' +
                ", m_contract='" + m_contract + '\'' +
                ", m_network='" + m_network + '\'' +
                ", m_match='" + m_match + '\'' +
                ", m_ad_extension='" + m_ad_extension + '\'' +
                ", m_adgroup_id='" + m_adgroup_id + '\'' +
                ", m_campaign_id='" + m_campaign_id + '\'' +
                ", m_campaign_group_id='" + m_campaign_group_id + '\'' +
                ", m_campaign_group='" + m_campaign_group + '\'' +
                ", m_account_id='" + m_account_id + '\'' +
                ", utm_source='" + utm_source + '\'' +
                ", utm_medium='" + utm_medium + '\'' +
                ", utm_campaign='" + utm_campaign + '\'' +
                ", utm_term='" + utm_term + '\'' +
                ", utm_content='" + utm_content + '\'' +
                ", adv_adgroup='" + adv_adgroup + '\'' +
                ", adv_ad='" + adv_ad + '\'' +
                ", adv_campaign='" + adv_campaign + '\'' +
                ", adv_creative='" + adv_creative + '\'' +
                ", adv_keyword='" + adv_keyword + '\'' +
                ", adv_agency='" + adv_agency + '\'' +
                ", adv_placement='" + adv_placement + '\'' +
                ", adv_cost_model=" + adv_cost_model +
                ", adv_cost=" + adv_cost +
                ", adv_currency='" + adv_currency + '\'' +
                ", attributionData=" + attributionData +
                '}';
    }
}
