package com.igaworks.v2.core.application;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.ui.inappmessage.InAppMessageManager;
import io.adbrix.sdk.utils.CommonUtils;

public class AbxActivityLifecycleCallbacks implements Application.ActivityLifecycleCallbacks {

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
//        AbxLog.d("onActivityCreated "+activity, true);
    }

    @Override
    public void onActivityStarted(Activity activity) {
//        AbxLog.d("onActivityStarted "+activity, true);
    }

    @Override
    public void onActivityResumed(Activity activity) {
//        AbxLog.d("onActivityResumed "+activity, true);
        InAppMessageManager.getInstance().setCurrentActivity(activity);
        DfnInAppMessage inAppMessage = InAppMessageManager.getInstance().getCarriedInAppMessage();
        if(CommonUtils.notNull(inAppMessage)){
            InAppMessageManager.getInstance().show(inAppMessage, null, true);
            InAppMessageManager.getInstance().flushCarriedInAppMessage();
        }
        AdBrixRm.onResume(activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
//        AbxLog.d("onActivityPaused "+activity, true);
        InAppMessageManager.getInstance().setCurrentActivity(activity);
        InAppMessageManager.getInstance().close(IAMEnums.CloseType.ON_PAUSE);
        InAppMessageManager.getInstance().setCurrentActivity(null);
        AdBrixRm.onPause(activity);
    }

    @Override
    public void onActivityStopped(Activity activity) {
//        AbxLog.d("onActivityStopped "+activity, true);
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
//        AbxLog.d("onActivitySaveInstanceState "+activity, true);
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
//        AbxLog.d("onActivityDestroyed "+activity, true);
//        AdBrixRm.stopController();
        AdBrixRm.onDestroy(activity);
    }
}
