package io.adbrix.sdk.push.utils;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;


import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.push.components.PushController;
import io.adbrix.sdk.push.models.AbxRemotePushModel;
import io.adbrix.sdk.push.style.BasePushStyle;
import io.adbrix.sdk.push.style.BigPicturePushStyle;
import io.adbrix.sdk.push.style.BigTextPushStyle;
import io.adbrix.sdk.push.style.IPushStyle;
import io.adbrix.sdk.utils.CommonUtils;

//TODO
public class AbxPushReceiverUtil {
    private AbxPushReceiverUtil(){}
    public static void callbackPushOpen(Context context, Intent intent){
        Bundle bundle = intent.getExtras();
        if (intent.getAction().equals(CompatConstants.REMOTE_PUSH_OPEN_CLICKED)) {
            remotePushOpenTracking(context, bundle);
            return;
        }
        if (intent.getAction().equals(CompatConstants.LOCAL_PUSH_OPEN_CLCKED)) {
            localPushOpenTracking(bundle);
            return;
        }
        AbxLog.d("Doesn't match with adbrix push open action", true);
    }

    public static void showNotification(Context context, Intent intent, AbxPushCommonDAO abxPushCommonDAO){
        IPushStyle pushStyle = getNotification(context, intent, abxPushCommonDAO);
        if(pushStyle == null){
            AbxLog.d("pushStyle is null", false);
        }
        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        int notificationId = pushStyle.getNotificationId();
        notificationManager.notify(notificationId, pushStyle.getNotification());
        AbxLog.d("showNotification id: "+notificationId, false);
    }

    private static IPushStyle getNotification(Context context, Intent intent, AbxPushCommonDAO abxPushCommonDAO){
        String action = intent.getAction();
        if(CompatConstants.PUSH_REMOTE_MESSAGE_RECEIVE.equals(action) ||
                CompatConstants.PUSH_REMOTE_MESSAGE_RECEIVE_FROM_FIREBASE_MESSAGING_SERVICE.equals(action)){
            String receivedJSONString = intent.getExtras().getString(ABXConstants.PUSH_REMOTE_FCM_KEY);
            try {
                JSONObject objFromServer = new JSONObject(receivedJSONString);
                JSONObject customAlertJSON = (JSONObject) objFromServer.get(ABXConstants.PUSH_REMOTE_KEY_CUSTOM_ALERT);
                String language = CommonUtils.getLanguage(context);
                AbxLog.d("Notification setting default language : " + language, false);
                JSONObject languageJson = PushUtils.getLanguageJson(language, customAlertJSON, objFromServer);
                String imageUrl = "";
                if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE)) {
                    if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE))){
                        imageUrl = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE);
                    }
                }
                if(!CommonUtils.isNullOrEmpty(imageUrl)){
                    return new BigPicturePushStyle(context, intent, abxPushCommonDAO);
                }
                String bigTextBody = "";
                if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY)) {
                    if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_BIG_BODY) && !CommonUtils.isNullOrEmpty(languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY))){
                        bigTextBody = languageJson.getString(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY);
                    }
                }
                if(!CommonUtils.isNullOrEmpty(bigTextBody)){
                    return new BigTextPushStyle(context, intent, abxPushCommonDAO);
                }
                return new BasePushStyle(context, intent, abxPushCommonDAO);
            } catch (JSONException e) {
                AbxLog.e("ERROR::Can't create JSON Object from received data", false);
            }
            return null;
        }
        if(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE.equals(action)){
            String style = intent.getExtras().getString(CompatConstants.PUSH_PROP_STYLE);
            if(CommonUtils.isNullOrEmpty(style)){
                AbxLog.d("style is empty", false);
                return null;
            }
            if(CompatConstants.PUSH_STYLE_BIG_TEXT.equals(style)){
                return new BigTextPushStyle(context, intent, abxPushCommonDAO);
            } else if(CompatConstants.PUSH_STYLE_BIG_PICTURE.equals(style)){
                return new BigPicturePushStyle(context, intent, abxPushCommonDAO);
            } else{
                AbxLog.d("Doesn't match with local notification style", false);
                return null;
            }
        }
        return null;
    }

    private static void localPushOpenTracking(Bundle bundle) {
        if (bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES) != null) {
            PushController.getInstance().callBackLocalPushMsg(bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES));
        } else if (bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES) != null) {
            PushController.getInstance().callBackLocalPushMsg(bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES));
        } else {
            AbxLog.d("ERROR :: can't call back local push msg ", true);
        }
    }

    private static void startPushButtonClickTracking(Context context, Bundle bundle) {
//        AbxPushCommonDAO.flushStackedPushList();
        AbxLog.d("Push Button Clicked", true);
        String deeplinkUrl = bundle.getString("buttonDeepLinkUrl");
        if (deeplinkUrl != null) {
            NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            notificationManager.cancel(0);
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(deeplinkUrl));
            try {
                context.startActivity(intent);
            } catch (Exception e) {
                AbxLog.d("DeepLinking failed.. please check your host and shceme", true);
            }
        }
    }

    private static void remotePushOpenTracking(Context context, Bundle bundle) {
        AbxLog.d("Start open-push tracking", true);
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel(context, bundle);
        JSONObject callBackJson = new JSONObject();
        try {
            if(!CommonUtils.isNullOrEmpty(abxRemotePushModel.deeplinkUrl)){
                callBackJson.put(ABXConstants.PUSH_REMOTE_KEY_DEEPLINKURL, abxRemotePushModel.deeplinkUrl);
            }
            if(abxRemotePushModel.deeplinkJson != null){
                callBackJson.put(ABXConstants.PUSH_REMOTE_KEY_DEEPLINKJSON, abxRemotePushModel.deeplinkJson);
            }
        } catch (JSONException e) {
            AbxLog.w("parsing error", false);
        }
        if (PushController.getInstance().remotePushMessageListener != null){
            PushController.getInstance().callBackRemotePushMsg(callBackJson.toString());
        }
        if(!abxRemotePushModel.isOpenPushEventParamAvailable()){
            AbxLog.e("Adbrix push tracking parameters don't exist!", false);
            return;
        }
        PushController.getInstance().pushEventTracking(abxRemotePushModel.toOpenPushEventParamJson());
    }
}
