package io.adbrix.sdk.push.style;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import io.adbrix.sdk.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.push.utils.PushUtils;
import io.adbrix.sdk.utils.CommonUtils;

public class BigTextPushStyle extends BigPushStyle {
    public BigTextPushStyle(Context context, Intent intent, AbxPushCommonDAO abxPushCommonDAO) {
        super(context, intent, abxPushCommonDAO);
    }

    @Override
    protected void setBigContentView() {
        if (android.os.Build.VERSION.SDK_INT < android.os.Build.VERSION_CODES.JELLY_BEAN) {
            return;
        }
        Notification.BigTextStyle style = new Notification.BigTextStyle();
        style.setBigContentTitle(PushUtils.fromHtml(bigTextTitle));
        if(CommonUtils.isNullOrEmpty(bigTextTitle)){
            style.setBigContentTitle(PushUtils.fromHtml(title));
        }
        if(!CommonUtils.isNullOrEmpty(bigTextBody)){
            style.bigText(PushUtils.fromHtml(bigTextBody));
        }
        if(!CommonUtils.isNullOrEmpty(summaryText)){
            style.setSummaryText(PushUtils.fromHtml(summaryText));
        }
        super.notificationBuilder.setStyle(style);
    }
}
