package io.adbrix.sdk.push.models;

import java.util.Date;

public class PushEvent {
    private int eventId;
    private Date notificationTime;

    public PushEvent(int eventId, long notificationTime) {
        this.eventId = eventId;
        this.notificationTime = new Date(notificationTime);
    }

    public int getEventId() {
        return eventId;
    }

    public Date getNotificationTime() {
        return notificationTime;
    }

    @Override
    public String toString() {
        return "PushEvent{" +
                "eventId=" + eventId +
                ", notificationTime=" + notificationTime +
                '}';
    }
}
