package io.adbrix.sdk.push.models;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.CommonUtils;

public class BigTextPushProperties extends PushProperties {
    protected String bigText;

    public BigTextPushProperties() {
        bigText = "";
    }


    public static BigTextPushProperties fromJSONObject(JSONObject jsonObject) {

        BigTextPushProperties bigTextPushProperties = new BigTextPushProperties();
        bigTextPushProperties.setFromJSONObject(jsonObject);
        return bigTextPushProperties;
    }

    public BigTextPushProperties setFromJSONObject(JSONObject jsonObject) {
        setSecond(jsonObject.optLong("second",0));
        setEventId(jsonObject.optInt("eventId",0));
        setTitle(jsonObject.optString("title"));
        setContentText(jsonObject.optString("contentText"));
        setSummaryText(jsonObject.optString("summaryText"));
        setBigContentTitle(jsonObject.optString("bigContentTitle"));
        setBigText(jsonObject.optString("bigText"));
        setDeepLinkUri(jsonObject.optString("deepLinkUri"));
        return this;
    }

    public String getBigText() {
        return bigText;
    }

    public BigTextPushProperties setBigText(String bigText) {
        this.bigText = bigText;
        return this;
    }

    public BigTextPushProperties setTitle(String title) {
        this.title = title;
        return this;
    }

    public BigTextPushProperties setSecond(long second) {
        this.second = second;
        return this;
    }

    public BigTextPushProperties setContentText(String contentText) {
        this.contentText = contentText;
        return this;
    }

    public BigTextPushProperties setSummaryText(String summaryText) {
        this.summaryText = summaryText;
        return this;
    }

    public BigTextPushProperties setBigContentTitle(String bigContentTitle) {
        this.bigContentTitle = bigContentTitle;
        return this;
    }

    public BigTextPushProperties setEventId(int eventId) {
        this.eventId = eventId;
        return this;
    }

    public BigTextPushProperties setDeepLinkUri(String deepLinkUri) {
        this.deepLinkUri = deepLinkUri;
        return this;
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        try {
            obj
                .put("second", second)
                .put("eventId", eventId)
                .put("title", title)
                .put("contentText", contentText)
                .put("summaryText", summaryText)
                .put("bigContentTitle", bigContentTitle)
                .put("bigText", bigText)
                .put("deepLinkUri", deepLinkUri);
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }
        return obj;
    }
}
