package io.adbrix.sdk.push.components;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.push.models.BigPicturePushProperties;
import io.adbrix.sdk.push.models.BigTextPushProperties;
import io.adbrix.sdk.push.utils.PushLocalBridgeUtil;

public class PushController {
    private static PushController INSTANCE;
    public static PushController getInstance(){
        if(INSTANCE == null){
            INSTANCE = new PushController();
        }
        return INSTANCE;
    }
    public interface onTouchLocalPushListener {
        void onTouchLocalPush(String callbackJsonString);
    }
    public interface onTouchRemotePushListener {
        void onTouchRemotePush(String callbackJsonString);
    }

    public onTouchRemotePushListener remotePushMessageListener;
    private onTouchLocalPushListener localPushMessageListener;
    private AbxFacade abxFacade;

    private PushController(){}

    public void init(AbxFacade abxFacade) {
        this.abxFacade = abxFacade;
        AbxLog.d("PushController : pushEnable & osPushEnable are initialized!", true);
    }

    public void setRemotePushMessageListener(onTouchRemotePushListener remotePushMessageListener) {
        this.remotePushMessageListener = remotePushMessageListener;
    }

    public void setLocalPushMessageListener(onTouchLocalPushListener localPushMessageListener) {
        this.localPushMessageListener = localPushMessageListener;
    }

    public void callBackLocalPushMsg(String msg) {
        if(this.localPushMessageListener == null){
            AbxLog.w("LocalPushMessageListener is null", false);
            return;
        }
        this.localPushMessageListener.onTouchLocalPush(msg);
    }

    public void callBackRemotePushMsg(String msg) {
        if(this.remotePushMessageListener == null){
            AbxLog.w("RemotePushMessageListener is null", false);
            return;
        }
        this.remotePushMessageListener.onTouchRemotePush(msg);
    }

    public boolean isPushAvailable(Intent intent){
        boolean result = false;
        try {
            result = abxFacade.isPushAvailable(intent);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    public void processPushOpen(Intent intent){
        abxFacade.processPushOpen(intent);
    }

    public void showNotification(Context context, Intent intent){
        abxFacade.showNotification(context, intent);
    }

    public void pushEventTracking(JSONObject pushOpenParam){
        abxFacade.pushEventTracking(pushOpenParam);
    }

    public boolean isForeground(){
        return abxFacade.isForeground();
    }

    public void insertPushData(String pushDataString){
        abxFacade.insertPushData(pushDataString);
    }
}
