package io.adbrix.sdk.push.components;

import org.json.JSONArray;
import org.json.JSONException;

/**
 * 푸쉬 이벤트 저장소
 */
public interface IPushEventStore {

    /**
     * 푸쉬 이벤트를 저장하고, 자동으로 생성된 아이디를 반환한다.
     * @param title
     * @param content
     * @param eventId
     * @param time
     * @param isStacked
     * @return
     */
    long insertOrReplacePushEventToTableAndGetId(String title, String content, int eventId, long time, int isStacked);

    /**
     * 푸쉬 이벤트 목록을 가져온다.
     * @return
     * @throws JSONException
     */
    JSONArray getPushEventList() throws JSONException;

    /**
     * 푸쉬 이벤트 목록을 가져온다.
     * TODO: isStacked가 뭐지;;
     * @param isStacked
     * @return
     * @throws JSONException
     */
    JSONArray getPushEventList(int isStacked) throws JSONException;

    /**
     * 푸쉬 이벤트 상태를 업데이트 한다.
     * @param id
     * @param state
     * @return
     */
    long updatePushEventState(int id, boolean state);

    /**
     * 푸쉬 이벤트를 삭제한다.
     * @param eventId
     * @return
     */
    long deletePushEvent(int eventId);
}
