package io.adbrix.sdk.domain.model;

import java.util.Map;

import javax.annotation.Nullable;

import io.adbrix.sdk.utils.CommonUtils;

public class LogEventParameter {
    public final String createAt;
    public final String prevId;
    public final String group;
    public final String eventName;
    @Nullable
    public Map<String, Object> eventParam;
    public final long sessionInterval; // Only for startSession
    public final long sessionLength; // Only for endSession
    public final long sessionOrderNo;
    public final long eventOrderNo;
    public String eventId;
    public String eventDatetime;

    public LogEventParameter(
            String group,
            String eventName,
            @Nullable
            Map<String, Object> eventParam,
            long sessionInterval,
            long sessionLength
    ) {
        long currentTimeMillis = System.currentTimeMillis();

        this.createAt = CommonUtils.getCurrentUTCInDBFormat(currentTimeMillis);
        this.prevId = null;
        this.eventId = CommonUtils.randomUUIDWithCurrentTime(currentTimeMillis);
        this.group = group;
        this.eventName = eventName;
        this.eventParam = eventParam;
        this.sessionInterval = sessionInterval;
        this.sessionLength = sessionLength;
        this.sessionOrderNo = 0L;
        this.eventOrderNo = 0L;
        this.eventDatetime = CommonUtils.getCurrentUTCInDBFormat(currentTimeMillis);
    }

    public LogEventParameter(
            String eventId,
            String prevId,
            String group,
            String eventName,
            @Nullable
            Map<String, Object> eventParam,
            long sessionInterval,
            long sessionLength,
            long sessionOrderNo,
            long eventOrderNo,
            String eventDatetime
    ) {
        this.createAt = CommonUtils.getCurrentUTCInDBFormat();
        this.prevId = prevId;
        this.eventId = eventId;
        this.group = group;
        this.eventName = eventName;
        this.eventParam = eventParam;
        this.sessionInterval = sessionInterval;
        this.sessionLength = sessionLength;
        this.sessionOrderNo = sessionOrderNo;
        this.eventOrderNo = eventOrderNo;
        this.eventDatetime = eventDatetime;
    }

    public LogEventParameter(
            String eventId,
            String prevId,
            String group,
            String eventName,
            @Nullable
            Map<String, Object> eventParam,
            long sessionInterval,
            long sessionLength,
            String eventDatetime
    ) {
        this.createAt = CommonUtils.getCurrentUTCInDBFormat();
        this.prevId = prevId;
        this.eventId = eventId;
        this.group = group;
        this.eventName = eventName;
        this.eventParam = eventParam;
        this.sessionInterval = sessionInterval;
        this.sessionLength = sessionLength;
        this.sessionOrderNo = 0L;
        this.eventOrderNo = 0L;
        this.eventDatetime = eventDatetime;
    }
}
