package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.CoreConstants;

public class DeferredDeeplinkModel implements IApiModel {
    private String platform;
    private String deviceId;
    private String appKey;

    public DeferredDeeplinkModel(
            String platform,
            String deviceId,
            String appKey
    ) {
        this.platform = platform;
        this.deviceId = deviceId;
        this.appKey = appKey;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject root = new NullableJSONObject();

        root.put("platform", platform);
        root.put("device_id", deviceId);

        return root;
    }

    @Override
    public String getUrlString() {
        return String.format(CoreConstants.deferredDeeplinkUrlReq, appKey);
    }
}
