package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class FetchInAppMessageUseCase implements UseCase<Empty> {
    private final Repository repository;
    private final Completion<Result<Empty>> completion;

    public FetchInAppMessageUseCase(Repository repository, Completion<Result<Empty>> completion) {
        this.repository = repository;
        this.completion = completion;
    }

    @Override
    public Empty execute() {
        repository.fetchInAppMessage(completion);
        return Empty.INSTANCE;
    }
}
