package io.adbrix.sdk.data.net;

import java.util.Map;

import io.adbrix.sdk.domain.model.IApiModel;

public interface IApiConnection {
    int getResponseCode();

    String getResponseString();

    IApiConnection header(Map<String, String> header);

    IApiConnection get(String urlString);

    IApiConnection get(IApiModel apiModel);

    IApiConnection post(IApiModel apiModel);

    IApiConnection delete(IApiModel apiModel);

    String request() throws Exception;

    boolean isHttpOK();

    boolean isWrongAppkey();

    boolean isInvalidAppkey();

    public enum RequestMethod {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE"),
        NONE("");

        private final String methodString;

        RequestMethod(String methodString) {
            this.methodString = methodString;
        }

        public String getMethodString() {
            return methodString;
        }
    }
}
