package io.adbrix.sdk.data.net;

import java.util.Map;

import io.adbrix.sdk.domain.model.IApiModel;

public class EmptyApiConnection implements IApiConnection{
    @Override
    public int getResponseCode() {
        return 0;
    }

    @Override
    public String getResponseString() {
        return "";
    }

    @Override
    public IApiConnection header(Map<String, String> header) {
        return this;
    }

    @Override
    public IApiConnection get(String urlString) {
        return this;
    }

    @Override
    public IApiConnection get(IApiModel apiModel) {
        return this;
    }

    @Override
    public IApiConnection post(IApiModel apiModel) {
        return this;
    }

    @Override
    public IApiConnection delete(IApiModel apiModel) {
        return this;
    }

    @Override
    public String request() throws Exception {
        return "";
    }

    @Override
    public boolean isHttpOK() {
        return false;
    }

    @Override
    public boolean isWrongAppkey() {
        return false;
    }

    @Override
    public boolean isInvalidAppkey() {
        return false;
    }
}
