package io.adbrix.sdk.data.inAppMessage;

import android.app.Activity;
import android.view.Window;
import android.view.WindowManager;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.IABXContextController;

public class NotFocusableAbxDialog extends AbxDialog {
    int previouslyWindowFlags = -1;
    public NotFocusableAbxDialog(Activity activity, IABXContextController controller) {
        super(activity, controller);
    }

    public NotFocusableAbxDialog(Activity activity, int themeResId, IABXContextController controller) {
        super(activity, themeResId, controller);
    }

    @Override
    public void show() {
        if (getOwnerActivity() != null && !getOwnerActivity().isFinishing()) {
            super.show();
            savePreviouslyWindowAttributesFlags();
            Window window = getWindow();
            if(window != null){
                window.setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
            }
            setInAppMessagePresented(true);
        } else {
            cancel();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        rollbackPreviouslyWindowAttributesFlags();
    }
    private void savePreviouslyWindowAttributesFlags(){
        Window window = getWindow();
        if(window == null){
            AbxLog.e("window is null", true);
            return;
        }
        previouslyWindowFlags = window.getAttributes().flags;
    }
    private void rollbackPreviouslyWindowAttributesFlags(){
        Window window = getWindow();
        if(window == null){
            AbxLog.e("window is null", true);
            return;
        }
        if(previouslyWindowFlags == -1){
            AbxLog.e("previouslyWindowFlags is -1", true);
            return;
        }
        WindowManager.LayoutParams windowManagerLayoutParams = window.getAttributes();
        windowManagerLayoutParams.flags = previouslyWindowFlags;
        window.setAttributes(windowManagerLayoutParams);
    }
}
