package io.adbrix.sdk.data.inAppMessage;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.DefaultABXContextController;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.domain.model.DfnInAppMessage;

public class InAppMessageFactoryContainer {
    private final FullScreenMessageViewFactory fullScreenMessageViewFactory;
    private final ModalMessageViewFactory modalMessageViewFactory;
    private final StickyBannerMessageViewFactory stickyBannerMessageViewFactory;

    private final String fullScreen = "full_screen";
    private final String modal = "modal";
    private final String stickyBanner = "sticky_banner";

    public InAppMessageFactoryContainer(InAppMessageDAO inAppMessageDAO, IABXContextController abxContextController) {
        fullScreenMessageViewFactory = new FullScreenMessageViewFactory(inAppMessageDAO,abxContextController);
        modalMessageViewFactory = new ModalMessageViewFactory(inAppMessageDAO,abxContextController);
        stickyBannerMessageViewFactory = new StickyBannerMessageViewFactory(inAppMessageDAO,abxContextController);
    }

    public IInAppMessageViewFactory getInAppMessageViewFactory(DfnInAppMessage inAppMessage) {
        switch (inAppMessage.getType()) {
            case fullScreen:
                return fullScreenMessageViewFactory;
            case modal:
                return modalMessageViewFactory;
            case stickyBanner:
                return stickyBannerMessageViewFactory;
            default:
                AbxLog.w("Invalid in app message type. Cannot get factory.", true);
                return null;
        }
    }
}
