package io.adbrix.sdk.data.inAppMessage;

import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.view.View;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.InAppMessageClickPostingObservable;
import io.adbrix.sdk.data.DFNSessionState;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.IAMEnums;

public interface IInAppMessageViewFactory  {
    void createInAppMessage(Activity activity, DfnInAppMessage inAppMessage, IObserver<AbxDialog> abxDialogIObserver);

    class InAppMessageOnClickListener implements View.OnClickListener {

        String campaignId;
        String actionId;
        String actionType;
        String actionArg;
        AbxDialog dialog;
        Runnable callback;
        InAppMessageDAO inAppMessageDAO;

        public InAppMessageOnClickListener(
                String campaignId,
                String actionId,
                String actionType,
                String actionArg,
                AbxDialog dialog,
                Runnable callback,
                InAppMessageDAO inAppMessageDAO
        ) {
            this.actionId = actionId;
            this.actionType = actionType;
            this.actionArg = actionArg;
            this.dialog = dialog;
            this.callback = callback;
            this.inAppMessageDAO = inAppMessageDAO;
            this.campaignId = campaignId;
        }

        @Override
        public void onClick(View v) {
            try {
                if (IAMEnums.ActionType.CLOSE.getValue().equals(actionType)) {
                    if (dialog != null) {
                        dialog.dismiss();
                        dialog.setInAppMessagePresented(false);
                    }
                } else if (IAMEnums.ActionType.WEBLINK.getValue().equals(actionType)) {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(actionArg));
                    try {
                        v.getContext().startActivity(intent);
                    } catch (ActivityNotFoundException exception) {
                        AbxLog.d("ModalMessageViewFactory: ActivityNotFoundException, button action url was " + actionArg, true);
                    }
                } else if (IAMEnums.ActionType.DEEPLINK_AND_CLOSE.getValue().equals(actionType) || IAMEnums.ActionType.WEBLINK_AND_CLOSE.getValue().equals(actionType)) {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(actionArg));
                    if (dialog != null) {
                        dialog.dismiss();
                        dialog.setInAppMessagePresented(false);
                    }

                    try {
                        v.getContext().startActivity(intent);
                    } catch (ActivityNotFoundException exception) {
                        AbxLog.d("ModalMessageViewFactory: ActivityNotFoundException, button action url was " + actionArg, true);
                    }
                } else if (IAMEnums.ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.getValue().equals(actionType)) {
                    SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("EE", Locale.ENGLISH);

                    long currentTimeMillis = System.currentTimeMillis() + TimeZone.getDefault().getRawOffset();
                    String currentDay = localSimpleDateFormat.format(System.currentTimeMillis());

                    inAppMessageDAO.updateOneDayCloseInAppMessageTable(campaignId, currentDay, currentTimeMillis);

                    if (dialog != null) {
                        dialog.dismiss();
                        dialog.setInAppMessagePresented(false);
                    }
                } else {
                    AbxLog.d("messageViewFactory: unknown button action '" + actionType + "'", true);
                }

                if (callback != null)
                    callback.run();

                InAppMessageClickPostingObservable.getInstance().postInAppMessageClickToMainThread(
                        actionId,
                        actionType,
                        actionArg,
                        IAMEnums.ActionType.CLOSE.getValue().equals(actionType)
                                || IAMEnums.ActionType.DEEPLINK_AND_CLOSE.getValue().equals(actionType)
                                || IAMEnums.ActionType.WEBLINK_AND_CLOSE.getValue().equals(actionType)
                                || IAMEnums.ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.getValue().equals(actionType)
                );
            } catch (NullPointerException nullPointerException) {
                AbxLog.d("NullPointerException in inAppMessage click action : " + nullPointerException.toString(), true);
            }
        }
    }
}
