package io.adbrix.sdk.data.inAppMessage;

import android.app.Activity;
import android.app.Dialog;

import io.adbrix.sdk.configuration.IABXContextController;

public class AbxDialog extends Dialog {
    private IABXContextController abxContextController;
    public AbxDialog(Activity activity, IABXContextController controller) {
        super(activity);
        setOwnerActivity(activity);
        this.abxContextController = controller;
    }

    public AbxDialog(Activity activity, int themeResId, IABXContextController controller) {
        super(activity, themeResId);
        setOwnerActivity(activity);
        this.abxContextController = controller;
    }

    @Override
    public void show() {
        if (getOwnerActivity() != null && !getOwnerActivity().isFinishing()) {
            super.show();
            setInAppMessagePresented(true);
        } else {
            cancel();
        }
    }

    public void setInAppMessagePresented(boolean state){
        this.abxContextController.getComponentsFactory().createOrGetDFNSessionState().setIsInAppMessagePresented(state);
    }

    public boolean isInAppMessagePresented(){
        return this.abxContextController.getComponentsFactory().createOrGetDFNSessionState().isInAppMessagePresented();
    }
}
