package io.adbrix.sdk.data.entity;

public enum DataRegistryKey {
    /**
     * 기존값은 수정하지 말고, 신규로 만들어야 한다.
     * ID는 안겹치게 해야 한다.
     */

    // (0에서부터 9까지)
    NONE(0, DataType.STRING),
    STRING_TEST(1, DataType.STRING),
    INT_TEST(2, DataType.INT),
    BOOLEAN_TEST(3, DataType.BOOLEAN),
    FLOAT_TEST(4, DataType.FLOAT),
    BOOLEAN_GDPR_FORGET_ME(5, DataType.BOOLEAN),
    STRING_SECRETKEY(6, DataType.STRING),
    BOOLEAN_LOCATION_PERMISSION_GRANTED(7, DataType.BOOLEAN),

    // COMMON (50에서부터 59까지)
    STRING_REQUEST_DATETIME(50, DataType.STRING),


    // COMMON - IDENTITY (10에서부터 29까지)
    STRING_ADID(10, DataType.STRING),
    STRING_UUID(11, DataType.STRING),
    STRING_IDFV(12, DataType.STRING),
    BOOLEAN_AD_ID_OPT_OUT(13, DataType.BOOLEAN),
    STRING_DEVICE_ID(14, DataType.STRING),
    STRING_REGISTRATION_ID(15, DataType.STRING),
    BOOLEAN_IS_PUSH_ENABLE(16, DataType.BOOLEAN),
    BOOLEAN_IS_PUSH_ENABLE_OS(17, DataType.BOOLEAN),
    STRING_IGAW_ID(18, DataType.STRING),
    STRING_IDFA(19, DataType.STRING),
    STRING_GAID(20, DataType.STRING),

    // COMMON - DEVICE_INFO (30에서부터 49까지)
    STRING_OS(30, DataType.STRING),
    STRING_MODEL(31, DataType.STRING),
    STRING_VENDOR(32, DataType.STRING),
    STRING_RESOLUTION(33, DataType.STRING),
    BOOLEAN_IS_PORTRAIT(34, DataType.BOOLEAN),
    STRING_PLATFORM(35, DataType.STRING),
    STRING_NETWORK(36, DataType.STRING),
    STRING_CARRIER(37, DataType.STRING),
    STRING_LANGUAGE(38, DataType.STRING),
    STRING_COUNTRY(39, DataType.STRING),
    INT_TIME_ZONE_OFFSET(40, DataType.INT),
    INT_DEVICE_TIME_TYPE(41, DataType.INT),
    BOOLEAN_IS_WIFI_ONLY(42, DataType.BOOLEAN),
    INT_BATT_L(43, DataType.INT),
    BOOLEAN_BATT_C(44, DataType.BOOLEAN),

    // COMMON (50에서부터 59까지, RequestDateTime: 50)
    STRING_PACKAGE_NAME(51, DataType.STRING),
    STRING_APPKEY(52, DataType.STRING),
    STRING_API_VERSION(53, DataType.STRING),
    STRING_SDK_VERSION(54, DataType.STRING),
    STRING_INSTALLER(55, DataType.STRING),
    STRING_APP_VERSION(56, DataType.STRING),
    STRING_BUILD_ID(57, DataType.STRING),


    // EVENT (60에서부터 80까지)
    STRING_LAST_FIRSTOPEN_ID(60, DataType.STRING),
    STRING_LAST_DEEPLINK_ID(61, DataType.STRING),
    STRING_LAST_OPEN_ID(62, DataType.STRING),
    STRING_PREV_ID(63, DataType.STRING),
    STRING_EVENT_DATETIME(64, DataType.STRING),
    STRING_GROUP(65, DataType.STRING),
    STRING_EVENT_NAME(66, DataType.STRING),
    STRING_PARAM(67, DataType.STRING),
    INT_SESSION_INTERVAL(68, DataType.INT),
    INT_SESSION_LENGTH(69, DataType.INT),
    STRING_LOG_ID(70, DataType.STRING),
    STRING_SESSION_ID(71, DataType.STRING),
    DOUBLE_LOCATION_LAT(72, DataType.DOUBLE),
    DOUBLE_LOCATION_LNG(73, DataType.DOUBLE),
    STRING_LOCATION_LWID(74, DataType.STRING),
    STRING_USER_SNAPSHOT_ID(75, DataType.STRING),
    STRING_USER_PROPERTIES(76, DataType.STRING),

    // 그 외, 필요한 것들
    BOOLEAN_IS_END_SESSION_SENT_LAST(77, DataType.BOOLEAN),
    STRING_LAST_CREATED_SESSION_ID(78, DataType.STRING),
    STRING_LAST_END_SESSION_ID(79, DataType.STRING),
    LONG_LAST_SESSION_CREATED_TIME(80, DataType.LONG),
    LONG_LAST_SESSION_END_TIME(81, DataType.LONG),
    LONG_GDPR_FORGETME(82, DataType.LONG),
    LONG_GDPR_FORGETME_SERVER_SYNC(83, DataType.LONG),
    STRING_S3_CONFIG_BLOCKED_EVTLIST(84, DataType.STRING),
    LONG_S3_CONFIG_APP_SCAN_PERIOD(85, DataType.LONG),
    LONG_S3_CONFIG_APP_SCAN_STOP(86, DataType.LONG),
    LONG_S3_CONFIG_PROPERTY_KEY_MAX(87, DataType.LONG),
    LONG_S3_CONFIG_ADBRIX_PAUSE(88, DataType.LONG),
    LONG_S3_CONFIG_ADBRIX_ALL_STOP(89, DataType.LONG),
    LONG_NEXT_APP_SCAN_TIME(90, DataType.LONG),
    STRING_SEND_DAILY_FIRST_OPEN_EVT(91, DataType.STRING),
    STRING_DAILY_FIRST_OPEN_PREV_DATE(92, DataType.STRING),
    STRING_ABX_NOTIFICATION_ID(93, DataType.STRING),
    LONG_APP_SCAN_ON_OFF_USER(94, DataType.LONG),
    STRING_USER_PROFILE(95, DataType.STRING),

    LONG_POP_UP_STOP_FLAG(96, DataType.LONG),
    STRING_PUSH_DB_SMALL_ICON_NAME(97, DataType.STRING),
    STRING_PUSH_DB_LARGE_ICON_NAME(98, DataType.STRING),
    LONG_PUSH_DB_ARGB(99, DataType.LONG),
    LONG_PUSH_DB_PRIORITY(100, DataType.LONG),
    LONG_PUSH_DB_VISIBILITY(101, DataType.LONG),
    LONG_PUSH_DB_USE_STACKING(102, DataType.LONG),
    LONG_PUSH_DB_USE_TITLE_FOR_STACKING(103, DataType.LONG),
    STRING_PUSH_DB_STACKING_CONTENT_TITLE(104, DataType.STRING),
    STRING_PUSH_DB_STACKING_CONTENT_TEXT(105, DataType.STRING),
    STRING_PUSH_DB_STACKING_BIG_CONTENT_TITLE(106, DataType.STRING),
    STRING_PUSH_DB_STACKING_BIG_CONTENT_SUMMARY_TEXT(107, DataType.STRING),
    STRING_PUSH_DB_NOTIFICATION_CHANNEL_NAME(108, DataType.STRING),
    STRING_PUSH_DB_NOTIFICATION_CHANNEL_DESCRIPTION(109, DataType.STRING),
    LONG_PUSH_DB_NOTIFICATION_CHANNEL_LIGHT(110, DataType.LONG),
    LONG_PUSH_DB_NOTIFICATION_CHANNEL_VIBRATE(111, DataType.LONG),
    LONG_PUSH_DB_IMPORTANCE(112, DataType.LONG),

    INT_PUSH_LIST_EVENT_ID_FIELD(113, DataType.INT),
    LONG_PUSH_LIST_TIME_FIELD(114, DataType.LONG),
    STRING_PUSH_LIST_TITLE_FIELD(115, DataType.STRING),
    STRING_PUSH_LIST_CONTENT_FIELD(116, DataType.STRING),
    INT_PUSH_LIST_STACKED_FIELD(117, DataType.INT),
    STRING_PUSH_ENABLE(118, DataType.STRING),

    STRING_UNSENT_EVENTPACKAGES(119, DataType.STRING),

    STRING_S3_CONFIG_SK_IP_PORT(120, DataType.STRING),
    INT_S3_CONFIG_SK_PING_VERSION(121, DataType.INT),
    INT_S3_CONFIG_SK_PING_PERIOD_SECOND(122, DataType.INT),

    BOOLEAN_IS_SDK_STOPPED(123, DataType.BOOLEAN),
    BOOLEAN_IS_SDK_STOPPED_SERVER_SYNC(124, DataType.BOOLEAN),
    STRING_INIT_RESTART_EVENT_DATETIME(125, DataType.STRING),

    BOOLEAN_IS_MIGRATED(126, DataType.BOOLEAN),

    STRING_LAST_ABX_TID(127, DataType.STRING),

    STRING_V1_UNSENT_EVENTS(128, DataType.STRING),

    STRING_S3_CONFIG_EVENT_SAMPLING_DATA(129, DataType.STRING),

    LONG_SESSION_ORDER_NO(130, DataType.LONG),
    LONG_EVENT_ORDER_NO(131, DataType.LONG),

    LONG_S3_CONFIG_TV_ATTRIBUTION_ACTIVE(132, DataType.LONG),
    STRING_DFN_ID(133, DataType.STRING),

    //InAppMessage는 300부터 사용합니다
    STRING_IN_APP_MESSAGE_CHECKSUM(300, DataType.STRING),
    INT_IN_APP_MESSAGE_MINUTES_TO_EXPIRY(301, DataType.INT),
    LONG_IN_APP_MESSAGE_LAST_RESPONSE_TIME(302, DataType.LONG),
    LONG_S3_CONFIG_IN_APP_MESSAGE_ACTIVE(303, DataType.LONG),
    STRING_IN_APP_MESSAGE_TOKEN(304, DataType.STRING),
    INT_IN_APP_MESSAGE_FETCH_MODE_VALUE(305, DataType.INT);

    final DataType dataType;
    //region enum을 안정적으로 사용하고 쉽게 파싱하기 위한 생성자 코드
    private final int id;

    DataRegistryKey(int id, DataType dataType) {
        this.id = id;
        this.dataType = dataType;
    }

    public static DataRegistryKey parseEnum(int id) {
        DataRegistryKey[] as = DataRegistryKey.values();
        for (int i = 0; i < as.length; i++) {
            if (as[i].compare(id)) {
                return as[i];
            }
        }
        return DataRegistryKey.NONE; //문자열을 디폴트값으로 하자.
    }

    public int getId() {
        return this.id;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean compare(int i) {
        return id == i;
    }
    //endregion
}
