package io.adbrix.sdk.data.dataprovider;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import java.util.Arrays;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.CommonUtils;

public class GoogleAdvertisingIdProvider implements IGoogleAdvertisingIdProvider {

    private Context context;
    public GoogleAdvertisingIdProvider(Context context)
    {
        this.context = context;
    }

    @Override
    public AdInfo getAdInfo() {
        AdvertisingIdClient.Info info = null;

        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo(context);
        } catch (Exception e) {
            AbxLog.w(Arrays.toString(e.getStackTrace()), true);
        }

        if (info != null && !CommonUtils.isNullOrEmpty(info.getId())) {
            return new AdInfo(info.getId(), info.isLimitAdTrackingEnabled());
        } else if ("Amazon".equals(Build.MANUFACTURER)) {
            ContentResolver contentResolver = context.getContentResolver();
            return new AdInfo(
                    Settings.Secure.getString(contentResolver, "advertising_id"),
                    Settings.Secure.getInt(contentResolver, "limit_ad_tracking", 0) == 1);
        } else {
            return new AdInfo(null, true);
        }
    }
}
