package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import com.google.firebase.messaging.RemoteMessage;

import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.UserPropertyCommand;
import io.adbrix.sdk.domain.model.UserPropertyModel;

public interface IABXContextController  {
    void changeABXContext(IABXContext newContext);

    //TODO: 생성자에서 아래로직을 처리하도록 해야함. (두번호출되면 안되기 때문)
    void startController(IABXComponentsFactory componentsFactory);

    void registerDataUnitEventListener();

    void stopController();

    IABXComponentsFactory getComponentsFactory();

    void initialize(Context context, String appkey, String secretkey);

    void saveUserProperty(UserPropertyCommand userPropertyCommand);

    void saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);

    void clearUserProperty();

    void getUserId(Completion<Result<String>> completion);

    void logEvent(LogEventParameter logEventParameter);

    void logSameEventWithPaging(String eventName, List<JSONObject> eventParamList);

    void flushAllEvents(Completion<Result<Empty>> completion);

    void onResume(Activity activity);

    void onPause();

    void onDestroy(Activity activity);

    void onMessageReceived(Context context, RemoteMessage remoteMessage);

    void deeplink(Activity deeplinkActivity);

    void deeplinkWithIntent(Intent deeplinkIntent);

    void gdprForgetMe();

    void putDataRegistry(DataUnit dataUnit);

    void runInBackGroundInOrder(Runnable runnable);

    void runInBackGroundWithoutOrder(Runnable runnable);

    void deleteUserDataAndStopSDK(String userId, Runnable onSuccess, Runnable onFail);

    void restartSDK(String userId, Runnable onSuccess, Runnable onFail);

    DataRegistry getDataRegistry() throws NullPointerException;

    UserPropertyModel getCurrentUserPropertyModel();

    void triggerInAppMessage(String eventGroup, String eventName);

    void fetchActionHistoryFromServer(String token, ActionHistoryIdType idType, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void insertPushData(String pushDataString);

    void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void deleteActionHistory(
            @Nullable String token,
            String historyId,
            long timestamp,
            Completion<Result<Empty>> completion
    );

    void deleteAllActionHistory(@Nullable String token, ActionHistoryIdType idType, Completion<Result<Empty>> completion);

    void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion);

    void clearAllActionHistoryInLocalDB();

    void fetchInAppMessage(Completion<Result<Empty>> completion);

    void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion);

    void openInAppMessage(String campaignId, Completion<Result<Empty>> completion);

    void deleteAllInAppMessageDBContents();

    void disableSDK(String disabledReason);
}
