package io.adbrix.sdk.component.autoEvent;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;

import java.util.HashMap;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.DeferredDeeplinkPostingObservable;
import io.adbrix.sdk.component.GooglePlayReferrerProperties;
import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.modelprovider.DeferredDeeplinkModelProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.data.net.IApiConnection;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.IApiModel;

public class FirstOpenAutoEventGenerator {
    private final Context androidContext;
    private final DataRegistry dataRegistry;
    private final IABXComponentsFactory componentsFactory;

    public FirstOpenAutoEventGenerator(
            DataRegistry dataRegistry,
            Context androidContext,
            IABXComponentsFactory componentsFactory
    ) {
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
        this.componentsFactory = componentsFactory;
    }

    public boolean isTrigger() {
        return dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_FIRSTOPEN_ID, null) == null;
    }

//    public Map<String, Object> getFirstOpenParam() {
//        //우선순위별 검사를 한다.
//        Map<String,Object> eventProperties = null;
//
//        //1. 구글 플레이 레퍼러
//        {
//            eventProperties = this.getGooglePlayReferrerPropertiesOrNull();
//            if(eventProperties != null) {
//                return eventProperties;
//            }
//        }
//
//        //2. No 레퍼러
//        {
//            return new HashMap<>();
//        }
//    }

    public Map<String, Object> getGooglePlayReferrerPropertiesOrNull() {
        HashMap<String, Object> referrerMap = new HashMap<>();
        try {
            GooglePlayReferrerProperties googlePlayReferrerProperties = new GooglePlayReferrerProperties(androidContext, componentsFactory);
            googlePlayReferrerProperties.startConnection();
            referrerMap.put("abx:market_install_btn_clicked", googlePlayReferrerProperties.referrerClickTime);
            referrerMap.put("abx:app_install_start", googlePlayReferrerProperties.appInstallTime);

            try {
                PackageInfo packageInfo = androidContext.getPackageManager().getPackageInfo(androidContext.getPackageName(), 0);
                referrerMap.put("abx:app_install_completed", (int) (packageInfo.firstInstallTime / 1000));
            } catch (PackageManager.NameNotFoundException e) {
                // Remaster에서는 (int) ( -1 / 1000) 을 사용했다.
                referrerMap.put("abx:app_install_completed", 0);
            }

            referrerMap.put("abx:referrer", googlePlayReferrerProperties.referrerUrl);
            referrerMap.put("abx:app_first_open", (int) (System.currentTimeMillis() / 1000));
            referrerMap.put("abx:click_adkey", googlePlayReferrerProperties.clickAdKey);
        }catch (Exception e)
        {
            AbxLog.e(e,false);
        }

        return referrerMap;
    }

    public void runDeferredDeeplinkProcess() {
        String adid;
        adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);

        AbxLog.d("getDeferredDeeplink start ::: ", true);
        if (adid != null) {
            ApiConnectionManager<Void> apiConnectionManager = new ApiConnectionManager<>(new ApiConnectionManager.Result<Void>() {
                @Override
                public void connectSuccess(String responseString, int responseCode, Void unused) {
                    AbxLog.d("Terminated FirstOpen", true);
                    AbxLog.i("API getDeferredDeeplink connectSuccess !! " + responseString, true);
                    DeferredDeeplinkPostingObservable.getInstance().postDeferredDeeplinkToMainThread(responseString);
                }

                @Override
                public void connectFail(int responseCode, Void unused) {
                    AbxLog.d("Terminated FirstOpen", true);
                    AbxLog.w("API getDeferredDeeplink connectFail !! ", true);
                    AbxLog.d("DeferredDeeplink responseCode : " + responseCode, true);
                }
            }, null);

            IApiModel deferredDeeplinkModel = new DeferredDeeplinkModelProvider(dataRegistry).provide();

            IApiConnection apiConnection = this.componentsFactory.createOrGetAPIConnection()
                    .post(deferredDeeplinkModel);

            /**
             * 2022.10.14 boobs
             * V1->V2 마이그레이션 과정에서 누락된 코드 추가
             * 디퍼드 딥링크가 동작하기 전 서버에 사전 작업이 있어 Delay가 필요하다고함
             */
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Thread.sleep(1500);
                        apiConnectionManager.executeWithRetry(apiConnection);
                    } catch (InterruptedException e) {
                        AbxLog.e(e, true);
                    }
                }
            }).start();

        } else {
            AbxLog.w("AdvertisingId null, so cannot get DeferredDeeplink data", true);
        }

    }
}
