package io.adbrix.sdk.component;

import java.util.ArrayList;
import java.util.List;

import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class InAppMessageAutoFetchObservable implements IObservable<Result<Empty>> {
    private List<IObserver<Result<Empty>>> observers = new ArrayList<>();

    private InAppMessageAutoFetchObservable() {
    }

    public static InAppMessageAutoFetchObservable getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void add(IObserver<Result<Empty>> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<Result<Empty>> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(Result<Empty> result) {
        for (IObserver<Result<Empty>> observer : observers) {
            observer.update(result);
        }
    }

    private static class Singleton {
        private static final InAppMessageAutoFetchObservable INSTANCE = new InAppMessageAutoFetchObservable();
    }
}
