package io.adbrix.sdk.component;

import android.content.Context;

import com.android.installreferrer.api.InstallReferrerClient;

import io.adbrix.sdk.component.autoEvent.DailyFirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.component.migration_v1.IV1DatabaseOpenHelper;
import io.adbrix.sdk.component.migration_v1.V1DatabaseOpenHelper;
import io.adbrix.sdk.component.migration_v1.V1MigrationManager;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.configuration.DefaultABXContextController;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.data.DFNSessionState;
import io.adbrix.sdk.data.RemoteConfigProvider;
import io.adbrix.sdk.data.dataprovider.DefaultNowaitEventNameProvider;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.dataprovider.GoogleAdvertisingIdProvider;
import io.adbrix.sdk.data.dataprovider.IGoogleAdvertisingIdProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.EmptyApiConnection;
import io.adbrix.sdk.data.net.IApiConnection;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.RepositoryImpl;
import io.adbrix.sdk.data.repository.datasource.DefaultDataContext;
import io.adbrix.sdk.data.repository.datasource.IDataContext;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.push.components.IPushEventStore;
import io.adbrix.sdk.push.components.PushController;
import io.adbrix.sdk.push.components.PushEventSqliteStore;

public class DefaultComponentsFactory implements IABXComponentsFactory {

    protected Context androidContext;
    protected AbxFacade abxFacade;
    protected IABXContext abxContext;
    protected IABXContextController defaultABXContextController;
    protected Lazy<ILogger> logger;
    protected Lazy<IDataContext> dataContext;
    protected Lazy<DataRegistry> dataRegistry;
    protected Lazy<Repository> repository;

    protected Lazy<DeviceRealtimeDataProvider> deviceRealtimeDataProvider;
    protected Lazy<DeviceStaticDataProvider> deviceStaticDataProvider;
    protected Lazy<UserPropertyManager> userPropertyManager;
    protected Lazy<V1MigrationManager> v1MigrationManager;
    protected Lazy<IEventSender> eventSender;
    protected Lazy<DeeplinkParameterSet> deeplinkParameterSet;
    protected Lazy<FirstOpenAutoEventGenerator> firstOpenAutoEventGenerator;
    protected Lazy<DeeplinkAutoEventGenerator> deeplinkAutoEventGenerator;
    protected Lazy<DailyFirstOpenAutoEventGenerator> dailyFirstOpenAutoEventGenerator;
    protected Lazy<SessionAutoEventGenerator> sessionAutoEventGenerator;
    protected Lazy<EventBuffer> eventBuffer;
    protected Lazy<EventPackageContainer> eventPackageContainer;
    protected Lazy<IV1DatabaseOpenHelper> v1DatabaseOpenHelper;
    protected Lazy<EventSamplingFilter> eventSamplingFilter;

    protected Lazy<IGoogleAdvertisingIdProvider> googleAdvertisingIdProvider;

    protected Lazy<IPushEventStore> pushEventStore;
    protected Lazy<AbxPushCommonDAO> pushCommonDAO;

    protected Lazy<DFNSessionState> dfnSessionState;
    protected Lazy<RemoteConfigProvider> remoteConfigProvider;

    @Override
    public void init(Context context, AbxFacade abxFacade, IABXContextController defaultABXContextController) {
        this.abxFacade = abxFacade;
        this.defaultABXContextController = defaultABXContextController;
        this.setAndroidContext(context);
        this.setupFactory(context);
    }

    @Override
    public IABXContextController getAbxContextController() {
        return this.defaultABXContextController;
    }

    /***
     * 컴포넌트 생성방식을 정의합니다.
     * 서브클래스에서 해당 방식을 재정의할 수 있습니다.
     */
    protected void setupFactory(Context androidContext) {
        this.logger = Lazy.of(() -> new DefaultLogger());
        this.dfnSessionState = Lazy.of(() -> new DFNSessionState());
        this.dataContext = Lazy.of(() -> new DefaultDataContext(getAndroidContext()));
        this.dataRegistry = Lazy.of(() -> new DataRegistry(createOrGetDataContext(), createOrGetLogger()));
        this.repository = Lazy.of(() -> new RepositoryImpl(this));
        this.googleAdvertisingIdProvider = Lazy.of(()-> new GoogleAdvertisingIdProvider(androidContext));
        this.deviceRealtimeDataProvider = Lazy.of(() -> new DeviceRealtimeDataProvider(createOrGetDataRegistry(), getAndroidContext(), this.googleAdvertisingIdProvider.get()));
        this.deviceStaticDataProvider = Lazy.of(() -> new DeviceStaticDataProvider(createOrGetDataRegistry(), getAndroidContext()));
        this.eventSender = Lazy.of(() -> new DefaultEventSender(createOrGetDataRegistry(), getAndroidContext(), createOrGetDeviceRealtimeDataProvider(),this));
        this.firstOpenAutoEventGenerator = Lazy.of(() -> new FirstOpenAutoEventGenerator(createOrGetDataRegistry(), getAndroidContext(),this));
        this.dailyFirstOpenAutoEventGenerator = Lazy.of(() -> new DailyFirstOpenAutoEventGenerator(createOrGetDataRegistry(), createOrGetRepository(), createOrGetDFNSessionState()));
        this.v1DatabaseOpenHelper = Lazy.of(() -> new V1DatabaseOpenHelper(getAndroidContext()));
        this.eventSamplingFilter = Lazy.of(() -> new EventSamplingFilter(createOrGetDataRegistry()));
        this.pushEventStore = Lazy.of(() ->PushEventSqliteStore.createAndGetPushEventSqliteStore(getAndroidContext()) );
        this.pushCommonDAO = Lazy.of(() -> new AbxPushCommonDAO(this.abxFacade, createOrGetPushEventStore()));
        this.remoteConfigProvider = Lazy.of(()->new RemoteConfigProvider(createOrGetDataRegistry(), this));

        this.userPropertyManager = Lazy.of(() ->new UserPropertyManager(createOrGetDataContext(),createOrGetLogger(),createOrGetDataRegistry()));
        this.deeplinkParameterSet = Lazy.of(() ->new DeeplinkParameterSet(createOrGetDataRegistry()));
        this.sessionAutoEventGenerator = Lazy.of(() ->new SessionAutoEventGenerator(createOrGetDataRegistry(),createOrGetFirstOpenAutoEventGenerator(),createOrGetRepository(),createOrGetDeeplinkParameterSet(),createOrGetV1MigrationManager(),createOrGetDFNSessionState()));
        this.deeplinkAutoEventGenerator = Lazy.of(() ->new DeeplinkAutoEventGenerator(createOrGetDataRegistry(),createOrGetDeeplinkParameterSet()));
        this.v1MigrationManager = Lazy.of(() ->new V1MigrationManager(createOrGetDataRegistry(),createOrGetUserPropertyManager(),createOrGetV1DatabaseOpenHelper(),createOrGetEventPackageContainer(),createOrGetRemoteConfigProvider()));
        this.eventPackageContainer = Lazy.of(() ->new EventPackageContainer(createOrGetEventSender(),createOrGetDataRegistry()));
        this.eventBuffer = Lazy.of(() ->new EventBuffer(createOrGetEventPackageContainer(),new DefaultNowaitEventNameProvider()));
    }

    @Override
    public Context getAndroidContext()  {
        return this.androidContext;
    }

    @Override
    public void setAndroidContext(Context context) {
        this.androidContext = context;
    }

    @Override
    public UserPropertyManager createOrGetUserPropertyManager(){
        return this.userPropertyManager.get();
    }

    @Override
    public IEventSender createOrGetEventSender() {
        return this.eventSender.get();
    }

    @Override
    public IABXContext getABXContext() {
        return this.abxContext;
    }

    @Override
    public void setABXContext(IABXContext context) {
        this.abxContext = context;
    }

    @Override
    public FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator()  {
        return this.firstOpenAutoEventGenerator.get();
    }

    @Override
    public SessionAutoEventGenerator createOrGetSessionAutoEventGenerator()  {
        return this.sessionAutoEventGenerator.get();
    }

    @Override
    public DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator()  {
        return this.deeplinkAutoEventGenerator.get();
    }



    @Override
    public ILogger createOrGetLogger() {
        try {
            return this.logger.get();
        } catch (Exception e) {
            return new DefaultLogger();
        }
    }

    @Override
    public DataRegistry createOrGetDataRegistry(){
        return this.dataRegistry.get();
    }

    @Override
    public IDataContext createOrGetDataContext() {
        return this.dataContext.get();
    }

    @Override
    public DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider()  {
        return this.deviceRealtimeDataProvider.get();
    }

    @Override
    public DeviceStaticDataProvider createOrGetDeviceStaticDataProvider() {
        return this.deviceStaticDataProvider.get();
    }

    @Override
    public V1MigrationManager createOrGetV1MigrationManager() {
        return this.v1MigrationManager.get();
    }

    @Override
    public DeeplinkParameterSet createOrGetDeeplinkParameterSet()  {
        return this.deeplinkParameterSet.get();
    }

    @Override
    public Repository createOrGetRepository()  {
        return this.repository.get();
    }

    @Override
    public EventBuffer createOrGetEventBuffer()  {
        return this.eventBuffer.get();
    }

    @Override
    public EventPackageContainer createOrGetEventPackageContainer()  {
        return this.eventPackageContainer.get();
    }

    @Override
    public DailyFirstOpenAutoEventGenerator createOrGetDailyFirstOpenAutoEventGenerator()  {
        return this.dailyFirstOpenAutoEventGenerator.get();
    }

    @Override
    public IV1DatabaseOpenHelper createOrGetV1DatabaseOpenHelper()  {
        return this.v1DatabaseOpenHelper.get();
    }

    @Override
    public EventSamplingFilter createOrGetEventSamplingFilter()  {
        return this.eventSamplingFilter.get();
    }

    @Override
    public IPushEventStore createOrGetPushEventStore()  {
        return this.pushEventStore.get();
    }

    @Override
    public AbxPushCommonDAO createOrGetPushCommonDAO()  {
        return this.pushCommonDAO.get();
    }

    @Override
    public IApiConnection createOrGetAPIConnection(){
        try {
            return ApiConnection.CreateAPIConnection(this.dataRegistry.get(), this.androidContext);
        } catch (Exception e) {
            AbxLog.e("APIConnection 초기화에 실패하여, 빈 APIConnection을 사용합니다. (아무런 동작도 하지 않습니다.)",true);
            return new EmptyApiConnection();
        }
    }

    @Override
    public InstallReferrerClient createOrGetInstallReferrerClient() {
        return InstallReferrerClient.newBuilder(this.androidContext).build();
    }

    @Override
    public DFNSessionState createOrGetDFNSessionState() {
        return this.dfnSessionState.get();
    }

    @Override
    public RemoteConfigProvider createOrGetRemoteConfigProvider() {
        return this.remoteConfigProvider.get();
    }

    @Override
    public void deactivate() {
        TimerManager.getInstance().setTimerToNull();
        EventUploadIntervalManager.getInstance().deleteAllObservers();
    }
}
