package io.adbrix.sdk.component;

import android.net.Uri;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class DeeplinkParameterSet {
    private HashSet<String> successParameterSet;
    private DataRegistry dataRegistry;

    public DeeplinkParameterSet(DataRegistry dataRegistry) {
        this.successParameterSet = new HashSet<>();
        this.dataRegistry = dataRegistry;
    }

    public boolean isAlreadyUsedDeeplinkParameter(Map<String, Object> eventParam) {
        String deeplinkAdKey = (String) eventParam.get(CoreConstants.DEEPLINK_ABX_ADKEY);
        String lastAbxTid = dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_ABX_TID, null);
        String deeplinkPayload = (String) eventParam.get(CoreConstants.DEEPLINK_PAYLOAD);

        if (deeplinkAdKey != null && successParameterSet.contains(deeplinkAdKey)) {
            AbxLog.d("deeplink_adkey : " + deeplinkAdKey + " is already used!", true);
            return true;
        }

        if (lastAbxTid != null && deeplinkAdKey != null && lastAbxTid.equals(deeplinkAdKey)) {
            AbxLog.d("deeplink_adkey : " + deeplinkAdKey + " is already used!", true);
            return true;
        }

        if (!CommonUtils.isNullOrEmpty(deeplinkPayload) && Uri.parse(deeplinkPayload).getQueryParameter(CoreConstants.IS_USED_APPLINK_KEY) != null
        && Boolean.valueOf(Uri.parse(deeplinkPayload).getQueryParameter(CoreConstants.IS_USED_APPLINK_KEY))) {
            AbxLog.d("applink : " + deeplinkPayload + " is already used!", true);
            return true;
        }

        if (deeplinkAdKey != null) {

            long currentTimeMillis = System.currentTimeMillis();
            long timeMillisFromAbxTid = getTimeMillisFromAbxTid(deeplinkAdKey);
            long diffInMillies = currentTimeMillis - timeMillisFromAbxTid;
            long diffInHours = TimeUnit.HOURS.convert(diffInMillies, TimeUnit.MILLISECONDS);

            if (diffInHours > 168) {
                AbxLog.d("deeplink_adkey : " + deeplinkAdKey + " is expired!", true);
                return true;
            }

            successParameterSet.add(deeplinkAdKey);
            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_LAST_ABX_TID,
                    deeplinkAdKey,
                    5,
                    this.getClass().getName(),
                    true
            ));
        }

        return false;
    }

    private long getTimeMillisFromAbxTid(String abxTid) {
        if (!abxTid.contains(":"))
            return 0L;

        if (abxTid.startsWith("ncpi")) {
            return Long.valueOf(abxTid.split(":")[1]);
        }

        return Long.valueOf(abxTid.split(":")[0]);
    }
}
