package com.igaworks.v2.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;

import com.google.firebase.messaging.RemoteMessage;
import com.igaworks.v2.core.application.AbxActivityHelper;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.IPairObserver;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryError;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.DfnInAppMessageFetchMode;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.push.models.PushEvent;
import io.adbrix.sdk.push.utils.PushUtils;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;
import io.adbrix.sdk.utils.ExtraUtils;

//import com.igaworks.v2.core.push.popup.Model.InAppBar;
//import com.igaworks.v2.core.push.popup.Model.InAppCarousel;
//import com.igaworks.v2.core.push.popup.Model.InAppFullImage;
//import com.igaworks.v2.core.push.popup.Model.InAppFullWebView;
//import com.igaworks.v2.core.push.popup.Model.InAppModal;
//import com.igaworks.v2.core.push.popup.PopUpHandler;
//import com.igaworks.v2.core.push.popup.PopUpUtils;

//TODO AdbrixRm은 v1 api를 맞춰주기위한 기능만 해야한다. 하지만 지금은 너무 많은 역할을 하고 있다. 이를 사용하는 클래스로 넘겨야 한다.
public class AdBrixRm {

    public static AbxGame Game;
    public static AbxCommon Common;
    public static AbxCommerce Commerce;
    private static DeferredDeeplinkListener deferredDeeplinkListener;
    private static DeeplinkListener deeplinkListener;
    private static InAppMessageClickListener inAppMessageClickListener;
    private static DfnInAppMessageAutoFetchListener dfnInAppMessageAutoFetchListener;
    private static LogListener logListener;
    private static boolean isLogListenerAvailable = false;
    private static boolean isDeeplinkEventWithIntentAvailable = false;

    static IABXComponentsFactory customComponentFactory = null;
    static boolean qaLogEnable = false;
    static AbxFacade abxFacade = null;

    private static String appKey;
    private static String secretKey;

    private AdBrixRm() {
    }

    public static synchronized void init(Context appContext, String appKey, String secretKey) {
        try {
            AdBrixRm.appKey = appKey;
            AdBrixRm.secretKey = secretKey;
            isLogListenerAvailable = isLogListenerAvailable(appContext);
            isDeeplinkEventWithIntentAvailable = isDeeplinkEventWithIntentAvailable(appContext);
            AbxLog.checkDebugAppInstalled(appContext);

            if(AbxActivityHelper.isInitialized){
                Log.d("abxrm", "AdBrixRm is already initialized");
                return;
            }
            AbxActivityHelper.isInitialized = true;

            abxFacade = new AbxFacade(
                    appContext,
                    appKey,
                    secretKey,
                    customComponentFactory
            );
            abxFacade.addObserverToDeferredDeeplinkPostingObservable(new DeferredDeeplinkObserver());
            abxFacade.addObserverToDeeplinkPostingObservable(new DeeplinkObserver());
            abxFacade.addObserverToInAppMessageClickPostingObservable(new InAppMessageClickObserver());
            abxFacade.addObserverToInAppMessageAutoFetchObservable(new InAppMessageFetchObserver());
            abxFacade.addObserverToOsPushEnableObservable(new OsPushEnableObserver());
        }catch (Exception e)
        {
            AbxLog.e("init fail >> Error: ",e, false);
        }
    }

    public static void stopController() {
        try {
            abxFacade.stopController();
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void login(final String userId) {
        try {
            abxFacade.runInBackGroundInOrder(new Runnable() {
                @Override
                public void run() {
                    if (isAdbrixDisabled()) return;
                    String userIdParam = userId;
                    if (CommonUtils.isNullOrEmpty(userIdParam)) {
                        userIdParam = "";
                        AbxLog.i("login: userId is null or empty >> Auto change to empty String", true);
                    }

                    boolean isLoginIdExist = abxFacade.isLoginIdExist(userIdParam);

                    UserProperties userProperties = new UserProperties();
                    userProperties.setAttrs("user_id", userIdParam);

                    // Updating userProperties before login to update user_id in user profile
                    if (userProperties.propertiesJson.length() > 0) {
                        saveUserPropertiesWithoutEvent(userProperties);
                    }

                    postAbxEvent(CompatConstants.EVENT_LOGIN);

                    // Updating userProperties after login to update user property and ci
                    if (userProperties.propertiesJson.length() > 0) {
                        if (!isLoginIdExist)
                            postAbxEvent(CompatConstants.EVENT_USER_PROPERTY_CHANGED);
                    }
                }
            });
        } catch (Exception e) {
            AbxLog.e("login >> Error: ",e, false);
        }
    }

    public static void logout() {
        try {
            abxFacade.runInBackGroundInOrder(new Runnable() {
                @Override
                public void run() {
                    if (isAdbrixDisabled()) return;

                    clearUserProperties();
                    abxFacade.clearAllActionHistoryInLocalDB();

                    if(abxFacade.isInAppMessageUserFetchMode()){
                        abxFacade.deleteAllInAppMessageDBContents();
                    }

                    postAbxEvent(CompatConstants.EVENT_LOGOUT);
                }
            });
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void gdprForgetMe(Context appContext) {
        try {
            abxFacade.gdprForgetMe();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setAge(int age) {
        try {
            if (isAdbrixDisabled()) return;

            UserProperties userProperties = new UserProperties();
            userProperties.setAttrs("age", age);

            saveUserProperties(userProperties);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setGender(AbxGender gender) {
        try {
            if (isAdbrixDisabled()) return;

            if (gender == null) {
                AbxLog.i("setGender: null value for gender >> Auto change null to AbxGender.UNKNOWN", true);
                gender = AbxGender.UNKNOWN;
            }

            UserProperties userProperties = new UserProperties();
            userProperties.setAttrs("gender", gender.getIntValue());

            saveUserProperties(userProperties);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    //With Event
    public static void saveUserProperties(UserProperties userProperties) {
        try {
            abxFacade.runInBackGroundInOrder(new Runnable() {
                @Override
                public void run() {
                    if (isAdbrixDisabled()) return;

                    if (userProperties == null) {
                        AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
                        return;
                    }

                    abxFacade.saveUserProperty(userProperties.propertiesJson);
                }
            });

        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    //Without Event
    private static void saveUserPropertiesWithoutEvent(UserProperties userProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (userProperties == null) {
                AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
                return;
            }

            abxFacade.saveUserPropertyWithoutEvent(userProperties.propertiesJson);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void clearUserProperties() {
        try {
            if (isAdbrixDisabled()) return;
            abxFacade.clearUserProperties();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setEnableLocationListening(Boolean isEnable) {
        try {
            if (isAdbrixDisabled()) return;
            abxFacade.setEnableLocationListening(isEnable);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setLocation(double latitude, double longitude) {
        try {
            if (isAdbrixDisabled()) return;
            abxFacade.setLocation(latitude, longitude);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void event(String eventName) {
        try {
            if (isAdbrixDisabled()) return;
            if (eventName == null) {
                AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
                return;
            }
            abxFacade.event(eventName);

        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void event(String eventName, AttrModel attrModel) {
        try {
            if (isAdbrixDisabled()) return;

            if (eventName == null) {
                AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
                return;
            }

            if (attrModel == null) {
                AbxLog.e("event:: null value for attrModel. Auto change null to Empty AttrModel.", false);
                attrModel = new AttrModel();
            }

            abxFacade.event(eventName, CommonUtils.parseValueWithDataType(attrModel.toJSONObject("custom event"), CommonUtils.FixType.PREFIX));
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void flushAllEvents(Completion<Result<Empty>> completion) {
        try {
            abxFacade.flushAllEvents(completion);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    private static void postAbxEvent(String eventName) {
        try {
            abxFacade.postAbxEvent(eventName);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    static void postAbxEvent(String eventName, JSONObject eventParam) {
        try {
            abxFacade.postAbxEvent(eventName, eventParam);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    static void postSameAbxEvent(List<CommerceProductModel> products, String eventName, JSONObject attributes) {
        try {
            List<List<CommerceProductModel>> listOfList = CommonUtils.split(products, CompatConstants.MAX_PRODUCT_LIST_LENGTH);
            List<JSONArray> jsonArrayList = new ArrayList<>();
            List<JSONObject> jsonObjectList = new ArrayList<>();
            for (List<CommerceProductModel> commerceProductModelList : listOfList) {
                JSONArray array = new JSONArray();
                try {
                    array = ExtraUtils.getProductJsonArrayForPurchase(commerceProductModelList);
                    jsonArrayList.add(array);
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
            }

            for (JSONArray productJsonArray : jsonArrayList) {
                jsonObjectList.add(
                        ExtraUtils.getCommerceEventParams(productJsonArray, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX)));
            }

            abxFacade.postSameAbxEvent(eventName, jsonObjectList);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void disableSDK(String reason){
        try {
            abxFacade.disableSDK(reason);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void onPause() {
        abxFacade.onPause(null);
    }

    public static void onPause(Activity activity) {
        try {
            abxFacade.onPause(activity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void onDestroy(Activity activity) {
        try {
            abxFacade.onDestroy(activity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void onResume(Activity activity) {
        try {
            abxFacade.onResume(activity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void onMessageReceived(Context context, RemoteMessage remoteMessage) {
        try {
            abxFacade.onMessageReceived(context, remoteMessage);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static boolean isAdbrixDisabled() {
        boolean result = false;
        try {
            result = abxFacade.isAdbrixDisabled();
        } catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    public static void setDeferredDeeplinkListener(DeferredDeeplinkListener deferredDeeplinkListener) {
        try {
            AdBrixRm.deferredDeeplinkListener = deferredDeeplinkListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setDeeplinkListener(DeeplinkListener deeplinkListener) {
        try {
            AdBrixRm.deeplinkListener = deeplinkListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setInAppMessageClickListener(InAppMessageClickListener inAppMessageClickListener) {
        try {
            AdBrixRm.inAppMessageClickListener = inAppMessageClickListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setDfnInAppMessageAutoFetchListener(DfnInAppMessageAutoFetchListener dfnInAppMessageAutoFetchListener) {
        try {
            AdBrixRm.dfnInAppMessageAutoFetchListener = dfnInAppMessageAutoFetchListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deeplinkEvent(Activity deeplinkActivity) {
        try {
            if (isAdbrixDisabled()) return;

            abxFacade.deeplink(deeplinkActivity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deeplinkEventWithIntent(Intent deeplinkIntent) {
        try {
            if (isAdbrixDisabled()) return;

            if (!isDeeplinkEventWithIntentAvailable) {
                AbxLog.d("deeplinkEventWithIntent API is not available!", true);
                return;
            }

            abxFacade.deeplinkWithIntent(deeplinkIntent);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static Uri getDeeplinkUriExceptAdbrixParameter(Uri uri) {
        try {
            return CoreUtils.getDeeplinkUriExceptAdbrixParameter(uri, AdBrixRm.appKey);
        }catch (Exception e){
            AbxLog.d("getDataRegistry is called before controller.startcontroller", true);
            return null;
        }
    }

    public static void setEventUploadCountInterval(AdBrixEventUploadCountInterval eventUploadCountInterval) {
        try {
            if (isAdbrixDisabled()) return;

            int minValue = AdBrixEventUploadCountInterval.MIN.getIntValue();
            int defValue = AdBrixEventUploadCountInterval.NORMAL.getIntValue();
            int maxValue = AdBrixEventUploadCountInterval.MAX.getIntValue();

            int countIntervalValue = eventUploadCountInterval.getIntValue();

            if (countIntervalValue != minValue && countIntervalValue != defValue && countIntervalValue != maxValue) {
                countIntervalValue = defValue;
            }

            abxFacade.setCountInterval(countIntervalValue);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setEventUploadTimeInterval(AdBrixEventUploadTimeInterval eventUploadTimeInterval) {
        try {
            if (isAdbrixDisabled()) return;

            int minValue = AdBrixEventUploadTimeInterval.MIN.getIntValue();
            int defValue = AdBrixEventUploadTimeInterval.NORMAL.getIntValue();
            int maxValue = AdBrixEventUploadTimeInterval.MAX.getIntValue();

            int timeIntervalValue = eventUploadTimeInterval.getIntValue();

            if (timeIntervalValue != minValue && timeIntervalValue != defValue && timeIntervalValue != maxValue) {
                timeIntervalValue = defValue;
            }

            abxFacade.setTimeInterval(timeIntervalValue);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setAppScanEnable(boolean enable) {
        try {
            if (isAdbrixDisabled()) return;
            abxFacade.setAppScanEnable(enable);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static boolean getPushEnable(){
        return abxFacade.getPushEnable();
    }

    public static boolean getOsPushEnable(){
        return abxFacade.getOsPushEnable();
    }
    public static void setRemotePushMessageListener(onTouchRemotePushListener remotePushMessageListener) {
        try {
            abxFacade.setRemotePushMessageListener(remotePushMessageListener::onTouchRemotePush);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setLocalPushMessageListener(onTouchLocalPushListener localPushMessageListener) {
        try {
            abxFacade.setLocalPushMessageListener(localPushMessageListener::onTouchLocalPush);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setPushEnable(boolean enable) {
        try {
            abxFacade.setPushEnable(enable);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setRegistrationId(String token) {
        try {
            abxFacade.setRegistrationID(token);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setBigTextClientPushEvent(Context ctx, BigTextPushProperties bigTextPushProp, boolean alwaysIsShown) {
        try {
            abxFacade.setBigTextClientPushEvent(ctx, bigTextPushProp, alwaysIsShown);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setBigPictureClientPushEvent(Context ctx, BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        try {
            abxFacade.setBigPictureClientPushEvent(ctx, bigPicturePushProperties, alwaysIsShown);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void cancelClientPushEvent(Context ctx, int eventId) {
        try {
            abxFacade.cancelClientPushEvent(ctx, eventId);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void cancelLocalPushNotification(Context ctx, int[] eventId) {
        try {
            abxFacade.cancelClientPushEvent(ctx, eventId);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void cancelLocalPushNotificationAll(Context ctx) {
        try {
            abxFacade.cancelClientPushEventAll(ctx);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static JSONArray getPushEventList() {
        return abxFacade.getPushEventList();
    }

    public static List<PushEvent> getRegisteredLocalPushNotification(){
        return abxFacade.getRegisteredLocalPushNotification();
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, int argb) {
        abxFacade.setPushIconStyle(context,smallIconName, largeIconName, argb);
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, PushColor color) {
        abxFacade.setPushIconStyle(context,smallIconName, largeIconName, color);
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconname) {
        setPushIconStyle(context, smallIconName, largeIconname, -1);
    }

    public static void setNotificationOption(Context context, int priority, int visibility) {
        abxFacade.setNotificationOption(priority, visibility);
    }

    public static void setNotificationChannel(Context context, String channelName, String channelDescription, int importance, boolean vibrateEnable) {
        abxFacade.setNotificationChannel(context,channelName,channelDescription,importance,vibrateEnable);
    }

    public static void setKakaoId(String kakaoId) {
        try {
            if (isAdbrixDisabled()) return;

            if (kakaoId == null) {
                AbxLog.w("Ignore setKakaoId function :: null value for kakaoId", true);
                return;
            }

            CiProperties ciProperties = new CiProperties();
            ciProperties.setAttrs("kakao_id", kakaoId);

            abxFacade.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void saveCiProperties(String key, Object value) {
        try {
            if (isAdbrixDisabled()) return;

            if (key == null || value == null) {
                AbxLog.w("Ignore setCustomci function :: null value for key or value", true);
                return;
            }

            CiProperties ciProperties = new CiProperties();
            ciProperties.setAttrs(key, value);

            abxFacade.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void saveCiProperties(CiProperties ciProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (ciProperties == null) {
                AbxLog.d("ciProperties are null!", false);
                return;
            }

            abxFacade.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static AbxRemotePushModel parsePushData(Map<String, String> pushDataMap){
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel();
        if (CommonUtils.isNullOrEmpty(pushDataMap)) {
            AbxLog.e("pushDataMap is null or empty!", false);
            return abxRemotePushModel;
        }

        try {
            String abxGfFcm = pushDataMap.get(ABXConstants.PUSH_REMOTE_FCM_KEY);
            if (abxGfFcm == null){
                return abxRemotePushModel;
            }
            JSONObject pushJson = new JSONObject();
            pushJson.put(ABXConstants.PUSH_REMOTE_FCM_KEY, new JSONObject(abxGfFcm));
            abxRemotePushModel = new AbxRemotePushModel(abxFacade.getContext(), pushJson);
            return abxRemotePushModel;
        }catch(Exception e){
            AbxLog.e(e, true);
            return abxRemotePushModel;
        }
    }

    public static AbxRemotePushModel parsePushData(RemoteMessage remoteMessage){
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel();
        if(remoteMessage == null){
            AbxLog.e("remoteMessage is null!", false);
            return abxRemotePushModel;
        }
        abxRemotePushModel = new AbxRemotePushModel(abxFacade.getContext(), remoteMessage);
        return abxRemotePushModel;
    }

    public static AbxRemotePushModel parsePushData(Bundle bundle){
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel();
        if(CommonUtils.isNullOrEmpty(bundle)){
            AbxLog.e("bundle is null or empty!", false);
            return abxRemotePushModel;
        }
        abxRemotePushModel = new AbxRemotePushModel(abxFacade.getContext(), bundle);
        return abxRemotePushModel;
    }

    public static void openPush(AbxRemotePushModel abxRemotePushModel){
        try {
            if (isAdbrixDisabled()) {
                AbxLog.e("openPush :: Adbrix is disabled because of (GdprForgetMe || Pause || Stop || Delete)", false);
                return;
            }
            if (abxRemotePushModel == null) {
                AbxLog.e("abxRemotePushModel is null", false);
                return;
            }
            if(!abxRemotePushModel.isOpenPushEventParamAvailable()){
                AbxLog.e("Adbrix push tracking parameters don't exist!", false);
                return;
            }
            AbxLog.d("openPush event called! param : " + abxRemotePushModel.toOpenPushEventParamJson(), true);
            abxFacade.pushEventTracking(abxRemotePushModel.toOpenPushEventParamJson());
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteUserDataAndStopSDK(String userId, Runnable onSuccess, Runnable onFail) {
        try {
            abxFacade.deleteUserDataAndStopSDK(userId, onSuccess, onFail);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void restartSDK(String userId, Runnable onSuccess, Runnable onFail) {
        try {
            abxFacade.restartSDK(userId, onSuccess, onFail);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static String SDKVersion() {
        String result = "";
        try {
            result = abxFacade.getSDKVersion();
        } catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;

    }

    public static void getUserId(Completion<Result<String>> completion){
        abxFacade.runInBackGroundInOrder(new Runnable() {
            @Override
            public void run() {
                try {
                    abxFacade.getUserId(completion);
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
            }
        });
    }

    public static void setLogListener(LogListener logListener) {
        try {
            AdBrixRm.logListener = logListener;
            AbxLog.setLogObserver(new LogObserver());
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    private static boolean isLogListenerAvailable(Context context) {
        boolean result = false;
        try {
            ApplicationInfo appInfo;
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = appInfo.metaData;
                int bitcode = bundle.getInt("AdBrixCustomLogicFlag");
                boolean tempIsLogListenerAvailable = (bitcode % 2) == 1;

                AbxLog.d("isLogListenerAvailable: " + tempIsLogListenerAvailable, true);
                result = tempIsLogListenerAvailable;
            } catch (Exception e) {
                AbxLog.e(e, false);
            }
        } catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    private static boolean isDeeplinkEventWithIntentAvailable(Context context) {
        boolean result = false;
        try {
            ApplicationInfo appInfo;
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = appInfo.metaData;
                int bitcode = bundle.getInt("AdBrixCustomLogicFlag");

                boolean tempIsDeeplinkEventWithIntentAvailable = ((bitcode >> 1) % 2) == 1;

                AbxLog.d("isDeeplinkEventWithIntentAvailable: " + tempIsDeeplinkEventWithIntentAvailable, true);
                result = tempIsDeeplinkEventWithIntentAvailable;

            } catch (PackageManager.NameNotFoundException e) {
                AbxLog.e(e, false);
                return result;
            }
        } catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    public static void fetchActionHistoryByUserId(String token, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.fetchActionHistoryFromServer(token, ActionHistoryIdType.USER_ID, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void fetchActionHistoryByAdid(String token, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.fetchActionHistoryFromServer(token, ActionHistoryIdType.ADID, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void insertPushData(Map<String, String> data) {
        try {
            if (isAdbrixDisabled()) {
                AbxLog.d(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getErrorMessage(), false);
                return;
            }

            String pushDataString = data.get(ABXConstants.PUSH_REMOTE_FCM_KEY);

            if (pushDataString != null) {
                abxFacade.insertPushData(pushDataString);
            }
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.getActionHistory(skip, limit, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.getAllActionHistory(actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteActionHistory(
            String token,
            String historyId,
            long timestamp,
            Completion<Result<Empty>> completion
    ) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.deleteActionHistory(token, historyId, timestamp, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteAllActionHistoryByUserId(String token, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.deleteAllActionHistory(token, ActionHistoryIdType.USER_ID, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteAllActionHistoryByAdid(String token, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.deleteAllActionHistory(token, ActionHistoryIdType.ADID, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.clearSyncedActionHistoryInLocalDB(completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setInAppMessageFetchMode(DfnInAppMessageFetchMode mode) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            abxFacade.setInAppMessageFetchMode(mode);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setInAppMessageToken(String token) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            abxFacade.setInAppMessageToken(token);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void fetchInAppMessage(Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.fetchInAppMessage(completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.getAllInAppMessage(completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void openInAppMessage(String campaignId, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.openInAppMessage(campaignId, completion);

        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public enum AbxGender {
        MALE(2),
        FEMALE(1),
        UNKNOWN(0);

        private final int value;

        AbxGender(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public enum AdBrixEventUploadCountInterval {
        MIN(10),
        NORMAL(30),
        MAX(60);

        private final int value;

        AdBrixEventUploadCountInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    public enum AdBrixEventUploadTimeInterval {
        MIN(30_000),
        NORMAL(60_000),
        MAX(120_000);

        private final int value;

        AdBrixEventUploadTimeInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
    }

    /*
    Push notification, Pop-Up
     */
    public enum PushColor {
        WHITE, BLACK, BLUE, YELLOW, RED, GREEN
    }

    public interface DeferredDeeplinkListener {
        void onReceiveDeferredDeeplink(String uriStr);
    }

    public interface DeeplinkListener {
        void onReceiveDeeplink(String uriStr);
    }

    public interface InAppMessageClickListener {
        void onReceiveInAppMessageClick(
                String actionId,
                String actionType,
                String actionArg,
                boolean isClosed
        );
    }

    public interface onTouchLocalPushListener {
        void onTouchLocalPush(String callbackJsonString);
    }

    public interface onTouchRemotePushListener {
        void onTouchRemotePush(String callbackJsonString);
    }

    public interface LogListener {
        void onPrintLog(int level, String message);
    }

    public interface DfnInAppMessageAutoFetchListener {
        void onFetchInAppMessage(Result<Empty> result);
    }

    private static class DeferredDeeplinkObserver implements IObserver<String> {

        @Override
        public void update(String deferredDeeplink) {
            if (deferredDeeplinkListener == null) {
                AbxLog.w("deferredDeeplinkListener is null", true);
                return;
            }

            if (deferredDeeplink == null) {
                AbxLog.d("deferredDeeplink is null", true);
            } else {
                deferredDeeplinkListener.onReceiveDeferredDeeplink(deferredDeeplink);
            }
        }
    }

    private static class DeeplinkObserver implements IObserver<String> {

        @Override
        public void update(String deeplink) {
            if (deeplinkListener == null) {
                AbxLog.w("deeplinkListener is null", true);
                return;
            }

            if (deeplink == null) {
                AbxLog.d("deeplink is null", true);
            } else {
                deeplinkListener.onReceiveDeeplink(deeplink);
            }
        }
    }

    private static class InAppMessageClickObserver implements IObserver<HashMap<String, Object>> {
        private final String actionId = "actionId";
        private final String actionType = "actionType";
        private final String actionArg = "actionArg";
        private final String isClosed = "isClosed";

        @Override
        public void update(HashMap<String, Object> clickInformation) {
            if (inAppMessageClickListener == null) {
                AbxLog.w("inAppMessageClickListener is null", true);
                return;
            }

            if (clickInformation == null) {
                AbxLog.w("InAppMessage click information is null", true);
                return;
            }

            inAppMessageClickListener.onReceiveInAppMessageClick(
                    (String) clickInformation.get(actionId),
                    (String) clickInformation.get(actionType),
                    (String) clickInformation.get(actionArg),
                    (boolean) clickInformation.get(isClosed)
            );
        }
    }

    private static class OsPushEnableObserver implements IObserver<Boolean> {

        @Override
        public void update(Boolean object) {
            abxFacade.updateOsPushEnable(object);
        }
    }

    private static class InAppMessageFetchObserver implements IObserver<Result<Empty>> {

        @Override
        public void update(Result<Empty> result) {
            if (dfnInAppMessageAutoFetchListener != null)
                dfnInAppMessageAutoFetchListener.onFetchInAppMessage(result);
        }
    }

    public static class UserProperties {
        protected JSONObject propertiesJson = new JSONObject();

        public UserProperties setAttrs(String property, Object value) {
            addToUserProperties(property, value);
            return this;
        }

        private void addToUserProperties(String property, Object value) {
            if (isAdbrixDisabled()) return;

            if (CommonUtils.isNullOrEmpty(property)) {
                AbxLog.w("Ignore addToUserProperties function :: property is null or empty string", true);
                return;
            }

            if (value == null) {
                AbxLog.w(String.format("Ignore addToUserProperties function :: null value for property %s", property), true);
                return;
            }
            try {
                String convertKey = ExtraUtils.convertPermittedStr(property);
                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return;
                }
                if (convertKey.length() > ABXConstants.MAX_KEY_LENGTH) {
                    return;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    propertiesJson.put(convertKey, value);
                }

            } catch (JSONException e) {
                AbxLog.e(e, true);
            }
        }
    }

    public static class CiProperties extends UserProperties {
        @Override
        public CiProperties setAttrs(String property, Object value) {
            super.setAttrs(property, value);
            return this;
        }
    }

    public static class AttrModel {
        protected JSONObject properties = new JSONObject();

        public AttrModel setAttrs(String property, Object value) {
            try {

                String convertKey = ExtraUtils.convertPermittedStr(property);

                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return this;
                }
                if (convertKey.length() > ABXConstants.MAX_KEY_LENGTH) {
                    return this;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    properties.put(convertKey, value);
                }

            } catch (JSONException e) {
                AbxLog.e(e, true);
            }
            return this;
        }

        public JSONObject toJSONObject(String tag) {
            JSONObject obj = new JSONObject();
            try {
                if(properties != null){
                    obj = properties;
                }
                obj = CommonUtils.truncate(ExtraUtils.limitCustomKeyNumber(ExtraUtils.cloneJSONObject(obj), tag, abxFacade.getPropertyMaxSize()), abxFacade.getPropertyMaxSize());
            } catch (Exception e) {
                AbxLog.e(e, false);
            }

            return obj;
        }
    }

//    public static void showBarPopUp(Activity activity, InAppBar resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.BAR, resource);
//    }
//
//    public static void showModalPopUp(Activity activity, InAppModal resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.MODAL, resource);
//    }
//
//    public static void showWebViewPopUp(Activity activity, InAppFullWebView resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_WEB_VIEW, resource);
//    }
//
//    public static void showCarouselPopUp(Activity activity, InAppCarousel resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.CAROUSEL, resource);
//    }
//
//    public static void showFullImagePopUp(Activity activity, InAppFullImage resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_IMAGE, resource);
//    }

    public static class GameProperties {

        public static class TutorialComplete {

            protected Boolean isSkip = null;
            protected JSONObject gameProperties;

            public TutorialComplete() {
                gameProperties = new JSONObject();
            }

            public TutorialComplete setIsSkip(boolean isSkip) {
                this.isSkip = isSkip;
                return this;
            }

            public TutorialComplete setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                gameProperties = attrModel.toJSONObject("TutorialComplete");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.isSkip != null) {
                        obj.put(CompatConstants.ABX_GAME_IS_SKIP, isSkip);
                    }
                } catch (Exception e) {
                    AbxLog.e(e, false);
                }
                return obj;
            }
        }

        public static class LevelAchieved {

            protected Integer level = null;
            protected JSONObject gameProperties;

            public LevelAchieved() {
                this.gameProperties = new JSONObject();
            }

            public LevelAchieved setLevel(int level) {
                this.level = level;
                return this;
            }

            public LevelAchieved setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("LevelAchieved");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.level != null) {
                        obj.put(CompatConstants.ABX_GAME_LEVEL, level);
                    }
                }catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
        }

        public static class CharacterCreated {

            protected JSONObject gameProperties;

            public CharacterCreated() {
                this.gameProperties = new JSONObject();
            }

            public CharacterCreated setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("CharacterCreated");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                }catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
        }

        public static class StageCleared {

            protected String stageName = null;
            protected JSONObject gameProperties;

            public StageCleared() {
                this.gameProperties = new JSONObject();
            }

            public StageCleared setStageName(String stageName) {
                this.stageName = stageName;
                return this;
            }

            public StageCleared setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("StageCleared");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.stageName != null){
                        obj.put(CompatConstants.ABX_GAME_STAGE_NAME, stageName);
                    }
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
        }
    }

    /*
     Excluded for privacy reasons
     */
//    public static void setPhoneNumber(String phoneNumber){
//        if (checkAdbrixPause()) return;
//
//        if (phoneNumber == null) {
//            Log.w(ABXConstants.LOGTAG, "Ignore setPhoneNumber function :: null value for phoneNumber");
//            return;
//        }
//
//        CiProperties ciProperties = new CiProperties();
//        ciProperties.setAttrs("phone_number", phoneNumber);
//
//        CoreWrapper.saveCi(ciProperties.propertiesJson);
//    }

    public static class CommonProperties {

        public static class Purchase {

            protected JSONObject commonProperties;

            public Purchase() {
                this.commonProperties = new JSONObject();
            }

            public Purchase setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Purchase");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "Purchase", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
        }

        public static class SignUp {

            protected JSONObject commonProperties;

            public SignUp() {
                this.commonProperties = new JSONObject();
            }

            public SignUp setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("SignUp");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "SignUp", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }

                return obj;
            }
        }

        public static class UseCredit {
            protected JSONObject commonProperties;

            public UseCredit() {
                this.commonProperties = new JSONObject();
            }

            public UseCredit setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("UseCredit");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "UseCredit", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }

                return obj;
            }
        }

        public static class AppUpdate {

            protected JSONObject commonProperties;

            protected String prevVer;
            protected String currVer;

            public AppUpdate() {
                this.commonProperties = new JSONObject();
                this.prevVer = null;
                this.currVer = null;
            }

            public AppUpdate setPrevVersion(String prevVer) {
                this.prevVer = prevVer;
                return this;
            }

            public AppUpdate setCurrVersion(String currVer) {
                this.currVer = currVer;
                return this;
            }

            public String getPrevVer() {
                return this.prevVer;
            }

            public String getCurrVer() {
                return this.currVer;
            }

            public AppUpdate setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("AppUpdate");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.prevVer != null) obj.put(CompatConstants.ABX_APP_PREV_VER, prevVer);
                    if (this.currVer != null) obj.put(CompatConstants.ABX_APP_CURR_VER, currVer);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "AppUpdate", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }

                return obj;
            }
        }

        public static class Invite {

            protected JSONObject commonProperties;

            public Invite() {
                this.commonProperties = new JSONObject();
            }

            public Invite setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Invite");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "Invite", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
        }
    }

    public static class CommonSignUpChannel {
        public static final CommonSignUpChannel Kakao = new CommonSignUpChannel("Kakao");
        public static final CommonSignUpChannel Naver = new CommonSignUpChannel("Naver");
        public static final CommonSignUpChannel Line = new CommonSignUpChannel("Line");
        public static final CommonSignUpChannel Google = new CommonSignUpChannel("Google");
        public static final CommonSignUpChannel Facebook = new CommonSignUpChannel("Facebook");
        public static final CommonSignUpChannel Twitter = new CommonSignUpChannel("Twitter");
        public static final CommonSignUpChannel whatsApp = new CommonSignUpChannel("whatsApp");
        public static final CommonSignUpChannel QQ = new CommonSignUpChannel("QQ");
        public static final CommonSignUpChannel WeChat = new CommonSignUpChannel("WeChat");
        public static final CommonSignUpChannel UserId = new CommonSignUpChannel("UserId");
        public static final CommonSignUpChannel ETC = new CommonSignUpChannel("ETC");
        public static final CommonSignUpChannel SkTid = new CommonSignUpChannel("SkTid");
        public static final CommonSignUpChannel AppleId = new CommonSignUpChannel("AppleId");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int UserIdIdx = 10;
        public static final int ETCIdx = 11;
        public static final int SkTidIdx = 12;
        public static final int AppleIdIdx = 13;

        public String channel;

        public CommonSignUpChannel(String channel) {
            this.channel = channel;
        }

        public static CommonSignUpChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(UserId.getChannel())) {
                return UserId;
            } else if (channel.equalsIgnoreCase(SkTid.getChannel())) {
                return SkTid;
            } else if (channel.equalsIgnoreCase(AppleId.getChannel())) {
                return AppleId;
            } else {
                return ETC;
            }

        }

        public static CommonSignUpChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else if (channel == UserIdIdx) {
                return UserId;
            } else if (channel == SkTidIdx) {
                return SkTid;
            } else if (channel == AppleIdIdx) {
                return AppleId;
            } else {
                return ETC;
            }
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommonInviteChannel {
        public static final CommonInviteChannel Kakao = new CommonInviteChannel("Kakao");
        public static final CommonInviteChannel Naver = new CommonInviteChannel("Naver");
        public static final CommonInviteChannel Line = new CommonInviteChannel("Line");
        public static final CommonInviteChannel Google = new CommonInviteChannel("Google");
        public static final CommonInviteChannel Facebook = new CommonInviteChannel("Facebook");
        public static final CommonInviteChannel Twitter = new CommonInviteChannel("Twitter");
        public static final CommonInviteChannel whatsApp = new CommonInviteChannel("whatsApp");
        public static final CommonInviteChannel QQ = new CommonInviteChannel("QQ");
        public static final CommonInviteChannel WeChat = new CommonInviteChannel("WeChat");
        public static final CommonInviteChannel ETC = new CommonInviteChannel("ETC");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int ETCIdx = 10;

        public String channel;

        public CommonInviteChannel(String channel) {
            this.channel = channel;
        }

        public static CommonInviteChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public static CommonInviteChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommerceProductModel {
        protected String productID = "";
        protected String productName = "";
        protected double price = 0.0;
        protected int quantity = 1;
        protected double discount = 0.0;
        protected double sales = 0.0;
        protected Currency currency;
        protected CommerceCategoriesModel category;
        protected JSONObject extraAttrs;

        public CommerceProductModel() {
            this.extraAttrs = new JSONObject();
        }

        public String getProductID() {
            return productID;
        }

        public CommerceProductModel setProductID(String productID) {
            this.productID = productID;
            return this;
        }

        public String getProductName() {
            return productName;
        }

        public CommerceProductModel setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public double getPrice() {
            return price;
        }

        public CommerceProductModel setPrice(double price) {
            this.price = price;
            return this;
        }

        public int getQuantity() {
            return quantity;
        }

        public CommerceProductModel setQuantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public double getDiscount() {
            return discount;
        }

        public CommerceProductModel setDiscount(double discount) {
            this.discount = discount;
            return this;
        }

        public Currency getCurrency() {
            return currency;
        }

        public CommerceProductModel setCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public CommerceCategoriesModel getCategory() {
            return category;
        }

        public CommerceProductModel setCategory(CommerceCategoriesModel category) {
            this.category = category;
            return this;
        }

        public CommerceProductModel setAttrModel(AttrModel attrModel) {
            if (attrModel == null) return this;

            this.extraAttrs = attrModel.toJSONObject("CommerceProductModel");
            return this;
        }

        public JSONObject getAttrs() {
            return extraAttrs;
        }
    }

    public static class CommerceCategoriesModel {
        static final int MAX_COMMERCE_CATEGORY_NUMBER = 5;
        public LinkedList<String> categoriesLinkedList = new LinkedList<String>();

        public CommerceCategoriesModel() {
        }

        public CommerceCategoriesModel setCategory(String category) {
            if (categoriesLinkedList.size() < MAX_COMMERCE_CATEGORY_NUMBER) {
                if (!CommonUtils.isNullOrEmpty(category)) this.categoriesLinkedList.add(category);
            } else
                AbxLog.d("Skip adding more categories, MAX_COMMERCE_CATEGORY_NUMBER is " + MAX_COMMERCE_CATEGORY_NUMBER, true);
            return this;
        }
    }

    public static class Currency {
        public static final Currency KR_KRW = new Currency("KR", "KRW");
        public static final Currency US_USD = new Currency("US", "USD");
        public static final Currency JP_JPY = new Currency("JP", "JPY");
        public static final Currency EU_EUR = new Currency("EU", "EUR");
        public static final Currency UK_GBP = new Currency("UK", "GBP");
        public static final Currency CN_CNY = new Currency("CH", "CNY");
        public static final Currency TW_TWD = new Currency("TW", "TWD");
        public static final Currency HK_HKD = new Currency("HK", "HKD");
        //added new currency 2017-09-08 by john
        public static final Currency ID_IDR = new Currency("ID", "IDR"); //Indonesia
        public static final Currency IN_INR = new Currency("IN", "INR"); //India
        public static final Currency RU_RUB = new Currency("RU", "RUB"); //Russia
        public static final Currency TH_THB = new Currency("TH", "THB"); //Thailand
        public static final Currency VN_VND = new Currency("VN", "VND"); //Vietnam
        public static final Currency MY_MYR = new Currency("MY", "MYR"); //Malaysia

        public String country;
        public String code;

        public Currency(String country, String code) {
            this.country = country;
            this.code = code;
        }

        public static Currency getCurrencyByCurrencyCode(String currencyCode) {

            if (currencyCode.equalsIgnoreCase(KR_KRW.toString())) {
                return KR_KRW;
            } else if (currencyCode.equalsIgnoreCase(US_USD.toString())) {
                return US_USD;
            } else if (currencyCode.equalsIgnoreCase(JP_JPY.toString())) {
                return JP_JPY;
            } else if (currencyCode.equalsIgnoreCase(EU_EUR.toString())) {
                return EU_EUR;
            } else if (currencyCode.equalsIgnoreCase(UK_GBP.toString())) {
                return UK_GBP;
            } else if (currencyCode.equalsIgnoreCase(CN_CNY.toString())) {
                return CN_CNY;
            } else if (currencyCode.equalsIgnoreCase(TW_TWD.toString())) {
                return TW_TWD;
            } else if (currencyCode.equalsIgnoreCase(HK_HKD.toString())) {
                return HK_HKD;
            } else if (currencyCode.equalsIgnoreCase(ID_IDR.toString())) {
                return ID_IDR;
            } else if (currencyCode.equalsIgnoreCase(IN_INR.toString())) {
                return IN_INR;
            } else if (currencyCode.equalsIgnoreCase(RU_RUB.toString())) {
                return RU_RUB;
            } else if (currencyCode.equalsIgnoreCase(TH_THB.toString())) {
                return TH_THB;
            } else if (currencyCode.equalsIgnoreCase(VN_VND.toString())) {
                return VN_VND;
            } else if (currencyCode.equalsIgnoreCase(MY_MYR.toString())) {
                return MY_MYR;
            } else {
                return new Currency(currencyCode, currencyCode);
            }
        }

        public static Currency getCurrencyByCountryCode(String countryCode) {
            if (countryCode.equalsIgnoreCase(KR_KRW.getCountry())) {
                return KR_KRW;
            } else if (countryCode.equalsIgnoreCase(US_USD.getCountry())) {
                return US_USD;
            } else if (countryCode.equalsIgnoreCase(JP_JPY.getCountry())) {
                return JP_JPY;
            } else if (countryCode.equalsIgnoreCase(EU_EUR.getCountry())) {
                return EU_EUR;
            } else if (countryCode.equalsIgnoreCase(UK_GBP.getCountry())) {
                return UK_GBP;
            } else if (countryCode.equalsIgnoreCase(CN_CNY.getCountry())) {
                return CN_CNY;
            } else if (countryCode.equalsIgnoreCase(TW_TWD.getCountry())) {
                return TW_TWD;
            } else if (countryCode.equalsIgnoreCase(HK_HKD.getCountry())) {
                return HK_HKD;
            } else if (countryCode.equalsIgnoreCase(ID_IDR.getCountry())) {
                return ID_IDR;
            } else if (countryCode.equalsIgnoreCase(IN_INR.getCountry())) {
                return IN_INR;
            } else if (countryCode.equalsIgnoreCase(RU_RUB.getCountry())) {
                return RU_RUB;
            } else if (countryCode.equalsIgnoreCase(TH_THB.getCountry())) {
                return TH_THB;
            } else if (countryCode.equalsIgnoreCase(VN_VND.getCountry())) {
                return VN_VND;
            } else if (countryCode.equalsIgnoreCase(MY_MYR.getCountry())) {
                return MY_MYR;
            } else {
                return new Currency(countryCode, countryCode);
            }
        }

        public String getCountry() {
            return country;
        }

        @Override
        public String toString() {
            return code;
        }
    }

    public static class CommercePaymentMethod {
        public static final CommercePaymentMethod CreditCard = new CommercePaymentMethod("CreditCard");
        public static final CommercePaymentMethod BankTransfer = new CommercePaymentMethod("BankTransfer");
        public static final CommercePaymentMethod MobilePayment = new CommercePaymentMethod("MobilePayment");
        public static final CommercePaymentMethod ETC = new CommercePaymentMethod("ETC");

        public static final int CreditCardIdx = 1;
        public static final int BankTransferIdx = 2;
        public static final int MobilePaymentIdx = 3;
        public static final int ETCIdx = 4;


        public String method;

        public CommercePaymentMethod(String method) {
            this.method = method;
        }

        public static CommercePaymentMethod getMethodByMethodCode(String mehod) {
            if (mehod.equalsIgnoreCase(CreditCard.getMethod())) {
                return CreditCard;
            } else if (mehod.equalsIgnoreCase(BankTransfer.getMethod())) {
                return BankTransfer;
            } else if (mehod.equalsIgnoreCase(MobilePayment.getMethod())) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public static CommercePaymentMethod getMethodByMethodCode(int mehod) {
            if (mehod == CreditCardIdx) {
                return CreditCard;
            } else if (mehod == BankTransferIdx) {
                return BankTransfer;
            } else if (mehod == MobilePaymentIdx) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public String getMethod() {
            return method;
        }

        @Override
        public String toString() {
            return method;
        }
    }

    public static class CommerceSharingChannel {
        public static final CommerceSharingChannel Facebook = new CommerceSharingChannel("Facebook");
        public static final CommerceSharingChannel KakaoTalk = new CommerceSharingChannel("KakaoTalk");
        public static final CommerceSharingChannel KakaoStory = new CommerceSharingChannel("KakaoStory");
        public static final CommerceSharingChannel Line = new CommerceSharingChannel("Line");
        public static final CommerceSharingChannel whatsApp = new CommerceSharingChannel("whatsApp");
        public static final CommerceSharingChannel QQ = new CommerceSharingChannel("QQ");
        public static final CommerceSharingChannel WeChat = new CommerceSharingChannel("WeChat");
        public static final CommerceSharingChannel SMS = new CommerceSharingChannel("SMS");
        public static final CommerceSharingChannel Email = new CommerceSharingChannel("Email");
        public static final CommerceSharingChannel copyUrl = new CommerceSharingChannel("copyUrl");
        public static final CommerceSharingChannel ETC = new CommerceSharingChannel("ETC");

        public String channel;

        public CommerceSharingChannel(String channel) {
            this.channel = channel;
        }

        public static CommerceSharingChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(KakaoTalk.getChannel())) {
                return KakaoTalk;
            } else if (channel.equalsIgnoreCase(KakaoStory.getChannel())) {
                return KakaoStory;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(SMS.getChannel())) {
                return SMS;
            } else if (channel.equalsIgnoreCase(Email.getChannel())) {
                return Email;
            } else if (channel.equalsIgnoreCase(copyUrl.getChannel())) {
                return copyUrl;
            } else if (channel.equalsIgnoreCase(ETC.getChannel())) {
                return ETC;
            } else {
                return new CommerceSharingChannel(channel);
            }
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class PushProperties extends io.adbrix.sdk.push.models.PushProperties {}
    public static class BigTextPushProperties extends io.adbrix.sdk.push.models.BigTextPushProperties {
        public static BigTextPushProperties fromJSONObject(JSONObject jsonObject) {
            BigTextPushProperties properties = new BigTextPushProperties();
            properties.setFromJSONObject(jsonObject);
            return properties;
        }
        public BigTextPushProperties setBigText(String bigText) {
            super.bigText = bigText;
            return this;
        }

        public BigTextPushProperties setTitle(String title) {
            super.title = title;
            return this;
        }

        public BigTextPushProperties setSecond(long second) {
            super.second = second;
            return this;
        }

        public BigTextPushProperties setContentText(String contentText) {
            super.contentText = contentText;
            return this;
        }

        public BigTextPushProperties setSummaryText(String summaryText) {
            super.summaryText = summaryText;
            return this;
        }

        public BigTextPushProperties setBigContentTitle(String bigContentTitle) {
            super.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigTextPushProperties setEventId(int eventId) {
            super.eventId = eventId;
            return this;
        }

        public BigTextPushProperties setDeepLinkUri(String deepLinkUri) {
            super.deepLinkUri = deepLinkUri;
            return this;
        }
    }
    public static class BigPicturePushProperties extends io.adbrix.sdk.push.models.BigPicturePushProperties {
        public static BigPicturePushProperties fromJSONObject(JSONObject jsonObject) {
            BigPicturePushProperties properties = new BigPicturePushProperties();
            properties.setFromJSONObject(jsonObject);
            return properties;
        }

        public BigPicturePushProperties setResourceId(int resourceId) {
            super.resourceId = resourceId;
            return this;
        }

        public BigPicturePushProperties setBigPictureUrl(String bigPictureUrl) {
            super.bigPictureUrl = bigPictureUrl;
            return this;
        }

        public BigPicturePushProperties setTitle(String title) {
            super.title = title;
            return this;
        }

        public BigPicturePushProperties setSecond(long second) {
            super.second = second;
            return this;
        }

        public BigPicturePushProperties setContentText(String contentText) {
            super.contentText = contentText;
            return this;
        }

        public BigPicturePushProperties setSummaryText(String summaryText) {
            super.summaryText = summaryText;
            return this;
        }

        public BigPicturePushProperties setBigContentTitle(String bigContentTitle) {
            super.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigPicturePushProperties setEventId(int eventId) {
            super.eventId = eventId;
            return this;
        }

        public BigPicturePushProperties setDeepLinkUri(String deepLinkUri) {
            super.deepLinkUri = deepLinkUri;
            return this;
        }
    }

    public static class AbxRemotePushModel extends io.adbrix.sdk.push.models.AbxRemotePushModel {
        public AbxRemotePushModel(){
            super();
        }
        public AbxRemotePushModel(Context context, RemoteMessage remoteMessage){
            super(context, remoteMessage);
        }
        public AbxRemotePushModel(Context context, JSONObject pushJson){
            super(context, pushJson);
        }
        public AbxRemotePushModel(Context context, Bundle bundle){
            super(context, bundle);
        }
        public AbxRemotePushModel(String campaignId, int campaignRevisionNo, String stepId, String cycleTime){
            super(campaignId, campaignRevisionNo, stepId, cycleTime);
        }
    }

    public static class LogObserver implements IPairObserver<Integer, String> {

        @Override
        public void update(Integer level, String message) {
            if (!isLogListenerAvailable)
                return;

            if (AdBrixRm.logListener == null) {
                Log.w("abxrm", "LogListener is null!");
                return;
            }

            AdBrixRm.logListener.onPrintLog(level, message);
        }
    }
}
